"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.applyFlag = exports.doCreate = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _flags = _interopRequireDefault(require("./flags"));

var _options = require("./options");

var _exec = require("./exec");

var _create = _interopRequireDefault(require("../client/direct/create"));

var _states = require("../../lib/model/states");

var _help = require("../../lib/util/help");

var _get = require("./get");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugin-kubectl/controller/kubectl/create');
/** The create-like verbs we will handle */

const verbs = ['create', 'apply'];

const doCreate = (verb, command = 'kubectl') => args => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _help.isUsage)(args)) {
    return (0, _help.doHelp)(command, args);
  } else {
    if ((0, _options.isDryRun)(args)) {
      const raw = yield (0, _exec.exec)(args, undefined, command);

      if ((0, _options.isEntityFormat)((0, _options.formatOf)(args)) && !(0, _exec.reallyNeedsPty)(args)) {
        const entity = yield (0, _get.doGetAsEntity)(args, raw);
        return entity;
      } else {
        return raw.content.stdout;
      }
    } else {
      try {
        const response = yield (0, _create.default)(args, verb);

        if (response) {
          return response;
        } else {
          debug('createDirect falling through to CLI impl');
        }
      } catch (err) {
        if (err.code === 404) {
          throw err;
        } else {
          console.error('Error in direct create. Falling back to CLI create.', err.code, err);
        }
      } // Note: the kuiSourceRef info will be added by `doStatus` in
      // ./status.ts, which is called by `doExecWithStatus`


      return (0, _exec.doExecWithStatus)(verb, _states.FinalState.OnlineLike, command)(args);
    }
  }
});

exports.doCreate = doCreate;
const applyFlag = Object.assign({}, _flags.default, {
  viewTransformer: _get.viewTransformer
});
exports.applyFlag = applyFlag;

var _default = registrar => {
  verbs.forEach(verb => {
    const handler = doCreate(verb);
    registrar.listen(`/kubectl/${verb}`, handler, applyFlag);
    registrar.listen(`/k/${verb}`, handler, applyFlag);
  });
};

exports.default = _default;