"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.restoreAuth = exports.setAuth = void 0;

var _core = require("@kui-shell/core");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const localStorageKey = {
  auth: 'kui.k8s.auth'
};
/**
 * Model update
 *
 */

const setAuth = (kubeconfigString, ca, cafile) => {
  const auth = {
    kubeconfig: kubeconfigString,
    ca: ca,
    cafile
  };
  (0, _core.setHasAuth)('k8s', auth);
  (0, _core.Store)().setItem(localStorageKey.auth, JSON.stringify(auth));
};
/**
 * Model restore on browser reload
 *
 */


exports.setAuth = setAuth;

const restoreAuth = () => {
  const maybe = (0, _core.Store)().getItem(localStorageKey.auth);

  if (maybe) {
    try {
      (0, _core.setHasAuth)('k8s', JSON.parse(maybe));
    } catch (err) {
      console.error('error parsing k8s auth from localStorage', err);
    }
  }
};

exports.restoreAuth = restoreAuth;