"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _fqn = require("../../../controller/kubectl/fqn");

var _resource = require("../../model/resource");

var _util = require("../../../lib/util/util");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-kubectl');
/**
 * Extract the events
 *
 */

function command(tab, {
  metadata: {
    namespace,
    ownerReferences: [{
      apiVersion,
      kind,
      name
    }]
  }
}, args) {
  return `${(0, _util.getCommandFromArgs)(args)} get ${(0, _fqn.fqn)(apiVersion, (0, _core.encodeComponent)(kind), (0, _core.encodeComponent)(name), (0, _core.encodeComponent)(namespace || 'default'))} -o yaml`;
}
/**
 * Add an Involved Object mode button
 *
 */


const mode = {
  when: _resource.hasSingleOwnerReference,
  mode: {
    mode: 'ownerReference',
    kind: 'drilldown',
    showRelatedResource: true,
    label: strings('Show Owner Reference'),
    command
  }
};
var _default = mode;
exports.default = _default;