import jsonpath from '@kui-shell/jsonpath';
import { Arguments, Row, Table } from '@kui-shell/core';
import { KubeOptions } from '../../kubectl/options';
import { KubeItems, KubeResource } from '../../../lib/model/resource';
declare type ParsedQuery = ReturnType<typeof jsonpath.parse>;
/** map from column name to jsonpath */
declare type CustomColumns = {
    key: string;
    query: ParsedQuery;
}[];
/**
 * Generate a table Row for the given resource, using the queries from
 * the given CustomColumns.
 *
 */
export declare function evaluate(resource: KubeResource, args: Pick<Arguments<KubeOptions>, 'parsedOptions'>, drilldownCommand: string, kind: string, custo: CustomColumns): Row;
/** See ./watch.ts; it will send row updates here for parsing */
export declare function toKuiTableForUpdateFromCustomColumns(resource: KubeResource, args: Pick<Arguments<KubeOptions>, 'parsedOptions'>, drilldownCommand: string, kind: string, spec: string): Pick<Table, 'header' | 'body'>;
/** See ./get.ts; it will send full table (as KubeItems) here for parsing */
export declare function toKuiTableFromCustomColumns(list: KubeResource | KubeItems, args: Pick<Arguments<KubeOptions>, 'parsedOptions'>, drilldownCommand: string, kind: string, spec: string): Table;
export default toKuiTableFromCustomColumns;
