import { Arguments, KResponse, MultiModalResponse, Registrar, Table } from '@kui-shell/core';
import RawResponse from './response';
import { KubeOptions } from './options';
import { KubeTableResponse } from '../../lib/view/formatTable';
import { KubeResource } from '../../lib/model/resource';
/**
 * `kubectl get` as a table response
 *
 */
export declare function doGetAsTable(command: string, args: Arguments<KubeOptions>, response: RawResponse, verb?: string, fullKind?: string): Promise<KubeTableResponse>;
/**
 * `kubectl get --watch` as a table response, but for the special case
 * where there is nothing yet to display
 *
 */
/**
 * `kubectl get` as entity response
 *
 */
export declare function doGetAsEntity(args: Arguments<KubeOptions>, response: RawResponse): Promise<KubeResource | RawResponse>;
/**
 * `kubectl get` as entity response
 *
 */
export declare function doGetAsMMR(args: Arguments<KubeOptions>, resource: KubeResource): Promise<MultiModalResponse<KubeResource>>;
/**
 * This is the main handler for `kubectl get`. Here, we act as a
 * dispatcher: in `kubectl` a `get` can mean either get-as-table,
 * get-as-entity, or get-as-custom, depending on the `-o` flag.
 *
 */
export declare const doGet: (command: string) => (args: Arguments<KubeOptions>) => Promise<KResponse>;
/** KubeResource -> MultiModalResponse view transformer */
export declare function viewTransformer(args: Arguments<KubeOptions>, response: KResponse): Promise<ReturnType<typeof doGetAsMMR> | Table>;
/** KubeResource -> MultiModalResponse view transformer for `kubectl get` */
declare function viewTransformerForGet(args: Arguments<KubeOptions>, response: KubeResource): Promise<Table<import("@kui-shell/core").Row> | Promise<MultiModalResponse<KubeResource<import("../../lib/model/resource").KubeStatus, import("../../lib/model/resource").KubeMetadata>>>> | {
    apiVersion: string;
    kind: string;
    metadata: {
        name: string[];
        namespace: string;
    };
    toolbarText: {
        type: string;
        text: string;
    };
    modes: {
        mode: string;
        label: string;
        content: any;
        contentType: "yaml";
    }[];
};
export declare const getFlags: import("@kui-shell/core").CommandOptions & {
    viewTransformer: typeof viewTransformerForGet;
    noCoreRedirect: boolean;
};
/** Register a command listener */
export declare function getter(registrar: Registrar, command: string, cli?: string): void;
declare const _default: (registrar: Registrar) => void;
export default _default;
