import { Arguments, ExecOptions, ParsedOptions } from '@kui-shell/core';
import { FinalState } from '../../lib/model/states';
declare type EntityFormat = 'yaml' | 'json';
declare type TableFormat = 'wide' | string;
declare type CustomFormat = string;
declare type OutputFormat = EntityFormat | TableFormat | CustomFormat;
/** @return the -f or --filename option */
export declare function fileOf(args: Pick<Arguments<KubeOptions>, 'parsedOptions'>): string;
/** @return same as fileOf, but also specify whether this came from a -f or --filename option */
export declare function fileOfWithDetail(args: Pick<Arguments<KubeOptions>, 'parsedOptions'>): {
    filepath: string;
    isFor: 'f' | 'filename';
};
/** @return the -R or --recursive option */
export declare function isRecursive(args: Arguments<KubeOptions>): string | number | boolean | string[];
/** @return the -k or --kustomize option */
export declare function kustomizeOf(args: Arguments<KubeOptions>): string;
export declare function getFileForArgv(args: Arguments<KubeOptions>, addSpace?: boolean): string;
export declare function getFileFromArgv(args: Arguments<KubeOptions>): string;
export declare function formatOf({ parsedOptions }: Pick<Arguments<KubeOptions>, 'parsedOptions'>): OutputFormat;
export declare function isEntityFormat(format: OutputFormat): format is EntityFormat;
export declare function isEntityRequest(args: Arguments<KubeOptions>): boolean;
export declare function isCustomColumns(format: OutputFormat): format is TableFormat;
export declare function isDashHelp(args: Arguments<KubeOptions>): boolean;
export declare function isHelpRequest(args: Arguments<KubeOptions>): boolean;
export declare function isTableRequest(args: Pick<Arguments<KubeOptions>, 'parsedOptions'>): boolean;
export declare function isWatchRequest(args: Pick<Arguments<KubeOptions>, 'parsedOptions'>): boolean;
export declare function watchRequestFrom(args: Arguments<KubeOptions>, forceWatch?: boolean): "" | "--watch-only" | "-w" | "--watch";
export declare function isTableWatchRequest(args: Arguments<KubeOptions>): boolean;
export declare function getLabel({ parsedOptions }: Pick<Arguments<KubeOptions>, 'parsedOptions'>): string;
export declare function getLabelForArgv(args: Arguments<KubeOptions>): string;
/**
 * Due to deficiencies in yargs-parser (used by @kui-shell/core), the
 * form -lapp=name (i.e. without a whitespace after the -l) is not
 * parsed properly.
 */
export declare function hasLabel(args: Arguments<KubeOptions>): boolean;
/** @return the namespace as expressed in the command line, or undefined if not */
export declare function getNamespaceAsExpressed(args: Pick<Arguments<KubeOptions>, 'parsedOptions'>): string;
/** @return the namespace as expressed in the command line, or the default from context */
export declare function getNamespace(args: Arguments<KubeOptions>): Promise<string>;
/**
 * A variant of getNamespace where you *only* want to use what was
 * provided by the user in their command line.
 */
export declare function getNamespaceForArgv({ parsedOptions }: {
    parsedOptions: KubeOptions;
}): string;
/** @return the resource names array as expressed in the command line */
export declare function getResourceNamesForArgv(kindFromArgv: string, args: Arguments<KubeOptions>): string[];
export declare function getContext(args: Arguments<KubeOptions>): string;
/** e.g. for kubectl logs */
export declare function getContainer(args: Arguments<KubeOptions>, verb: string): string;
export declare function getContextForArgv(args: Arguments<KubeOptions>): string;
export interface KubeExecOptions extends ExecOptions {
    finalState: FinalState;
    nResourcesToWaitFor: number;
    /** e.g. kubectl delete followed by a watch; if the watch fails,
     * we'd like to report the initial response from the delete */
    initialResponse: string;
}
/** Options that specify a filepath */
export declare type FilepathOption = 'kubeconfig' | 'f' | 'filename' | 'k' | 'kustomize' | 'client-key' | 'client-certificate' | 'certificate-authority' | 'cache-dir';
/** An incomplete set of kubectl options */
export interface KubeOptions extends ParsedOptions {
    A?: boolean;
    'all-namespaces'?: boolean;
    cluster?: string;
    context?: string;
    kubeconfig?: string;
    'dry-run'?: boolean | string;
    n?: string;
    namespace?: string;
    c?: string;
    container?: string;
    o?: OutputFormat;
    output?: OutputFormat;
    w?: boolean;
    watch?: boolean;
    'watch-only'?: boolean;
    wait?: boolean;
    p?: boolean;
    previous?: boolean;
    l?: string;
    label?: string;
    f?: string;
    filename?: string;
    k?: string;
    kustomize?: string;
    h?: boolean;
    help?: boolean;
    limit?: number;
}
export declare function isForAllNamespaces(parsedOptions: KubeOptions): boolean;
/** Copy over any kubeconfig/context/cluster/namespace specifications from the given args */
export declare function withKubeconfigFrom(args: Pick<Arguments<KubeOptions>, 'parsedOptions'>, cmdline: string): string;
/** As with `withKubeconfigFrom`, and also copy over the leading command (e.g. `kubectl`) */
export declare function withKubeconfigAndCommandFrom(args: Pick<Arguments<KubeOptions>, 'argvNoOptions' | 'execOptions' | 'parsedOptions'>, cmdline: string): string;
/** Apply --dry-run? */
export declare function isDryRun(args: Arguments<KubeOptions>): boolean;
export declare function isDiffRequest(args: Arguments<KubeOptions>): boolean;
export default KubeOptions;
