/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { i18n } from '@kui-shell/core';
import { isPod } from '../../model/resource';
const strings = i18n('plugin-kubectl', 'logs');
export const mode = {
    mode: 'logs',
    label: strings('Logs'),
    // hack workaround to defer loading of plugin-client-common; needs update to babel-plugin-ignore-html-and-css-imports
    content: (tab, pod, args) => import('./logs').then(_ => _.content(tab, pod, args))
};
/**
 * The Summary mode applies to all KubeResources, and uses
 * `renderContent` to render the view.
 *
 */
const logsReg = {
    when: isPod,
    mode
};
export default logsReg;
//# sourceMappingURL=logs-mode.js.map