"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _pluginKubectl = require("@kui-shell/plugin-kubectl");

var _logs = require("@kui-shell/plugin-kubectl/logs");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const command = 'oc';

var _default = registrar => {
  registrar.listen(`/${command}/apply`, (0, _pluginKubectl.doCreate)('apply', command), _pluginKubectl.defaultFlags);
  registrar.listen(`/${command}/create`, (0, _pluginKubectl.doCreate)('create', command), _pluginKubectl.defaultFlags);
  registrar.listen(`/${command}/delete`, (0, _pluginKubectl.doDelete)(command), _pluginKubectl.defaultFlags);
  registrar.listen(`/${command}/run`, (0, _pluginKubectl.doRun)(command), _pluginKubectl.defaultFlags);
  (0, _pluginKubectl.getter)(registrar, command);
  (0, _pluginKubectl.describer)(registrar, command);
  (0, _pluginKubectl.registerConfig)(registrar, command);
  (0, _pluginKubectl.registerEdit)(registrar, command);
  (0, _pluginKubectl.registerApplySubcommands)(registrar, command);
  (0, _logs.registerExec)(registrar, command);
  (0, _logs.registerLogs)(registrar, command);
};

exports.default = _default;