/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { isHeadless } from '@kui-shell/core';
import { defaultFlags } from '@kui-shell/plugin-kubectl';
export default (registrar) => __awaiter(void 0, void 0, void 0, function* () {
    if (!isHeadless()) {
        const [{ topContainer, topPod }, { topNode }] = yield Promise.all([
            import('./controller/get-pod-data'),
            import('./controller/get-node-data')
        ]);
        // works around a defect in the core's `override` function; if the
        // plugin-kubectl is loaded before us, our override is ignored
        const top = (yield registrar.find('/kubectl/top/node', 'plugin-kubectl')).$;
        registrar.listen('/kubectl/top/node-summary', (args) => __awaiter(void 0, void 0, void 0, function* () {
            args.command = args.command.replace(/node-summary/, 'node --summary');
            args.parsedOptions.summary = true;
            return topNode(args, top);
        }), defaultFlags);
        registrar.override('/kubectl/top/node', 'plugin-kubectl', topNode, defaultFlags);
        registrar.override('/k/top/node', 'plugin-kubectl', topNode, defaultFlags);
        registrar.override('/kubectl/top/pod', 'plugin-kubectl', topPod, defaultFlags);
        registrar.override('/k/top/pod', 'plugin-kubectl', topPod, defaultFlags);
        registrar.listen('/kubectl/top/container', topContainer, defaultFlags);
        registrar.listen('/k/top/container', topContainer, defaultFlags);
    }
});
//# sourceMappingURL=plugin.js.map