/**
 * Released under MIT License
 * Copyright (c) 2021 cell.ts
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
import { IBufferCell } from 'xterm';
export declare const INVERTED_DEFAULT_COLOR = 257;
export declare const NULL_CELL_CODE = 0;
export declare const WHITESPACE_CELL_CHAR = " ";
export declare const enum Attributes {
    /**
     * bit 1..8     blue in RGB, color in P256 and P16
     */
    BLUE_MASK = 255,
    BLUE_SHIFT = 0,
    PCOLOR_MASK = 255,
    PCOLOR_SHIFT = 0,
    /**
     * bit 9..16    green in RGB
     */
    GREEN_MASK = 65280,
    GREEN_SHIFT = 8,
    /**
     * bit 17..24   red in RGB
     */
    RED_MASK = 16711680,
    RED_SHIFT = 16,
    /**
     * bit 25..26   color mode: DEFAULT (0) | P16 (1) | P256 (2) | RGB (3)
     */
    CM_MASK = 50331648,
    CM_DEFAULT = 0,
    CM_P16 = 16777216,
    CM_P256 = 33554432,
    CM_RGB = 50331648,
    /**
     * bit 1..24  RGB room
     */
    RGB_MASK = 16777215
}
export declare const BOLD_CLASS = "xterm-bold";
export declare const DIM_CLASS = "xterm-dim";
export declare const ITALIC_CLASS = "xterm-italic";
export declare const UNDERLINE_CLASS = "xterm-underline";
export declare const CURSOR_CLASS = "xterm-cursor";
export declare const CURSOR_BLINK_CLASS = "xterm-cursor-blink";
export declare const CURSOR_STYLE_BLOCK_CLASS = "xterm-cursor-block";
export declare const CURSOR_STYLE_BAR_CLASS = "xterm-cursor-bar";
export declare const CURSOR_STYLE_UNDERLINE_CLASS = "xterm-cursor-underline";
/**
 * Storing the styling from `_workCell` for Dom Renderer
 *
 * Attribution: from DomRenderRofFactory.createRow xterm v4.4.0
 *
 */
export default function prepareCellForDomRenderer(_workCell: IBufferCell): {
    classList: any[];
    textContent: any;
    style: {};
};
