"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _InputStripe = _interopRequireDefault(require("../Client/InputStripe"));

var _2 = require("../..");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}; // FIXME:

/* eslint-disable react/prop-types */


class Popup extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this._inputStripeRef = _react.default.createRef();
    const tabModel = new _2.TabModel();

    _core.eventBus.onceWithTabId('/tab/close/request', tabModel.uuid, (_, tab) => __awaiter(this, void 0, void 0, function* () {
      // tab close is window close for the popup client
      tab.REPL.qexec('window close', undefined, undefined, {
        tab
      });
    }));

    _core.eventBus.onCommandComplete(tabModel.uuid, ({
      tab,
      command,
      response
    }) => __awaiter(this, void 0, void 0, function* () {
      if (process.env.KUI_TEE_TO_FILE) {
        // tee the response to a file
        // maybe in the future we could do this better
        // e.g. hoistingit to Kui, making it driven off a property rather than env variable
        yield (0, _core.teeToFile)(response);
      }

      this.setState({
        promptPlaceholder: command
      });
      this.doFocusInput(); // see https://github.com/kubernetes-sigs/kui/issues/7268

      setTimeout(() => tab.scrollToBottom(), 50);
      setTimeout(() => tab.scrollToBottom(), 150);
    }));

    this.state = {
      tab: undefined,
      model: tabModel,
      promptPlaceholder: ''
    };
  }

  onTabReady(tab) {
    this.setState({
      tab
    });
    tab.REPL.pexec(this.props.commandLine.join(' '), {
      tab
    });
    this.doFocusInput();
  }

  doFocusInput() {
    if (this._inputStripeRef.current) {
      setTimeout(() => this._inputStripeRef.current.doFocus());
    }
  }

  render() {
    return _react.default.createElement("div", {
      className: "kui--full-height"
    }, _react.default.createElement(_2.TabContent, {
      noActiveInput: true,
      uuid: this.state.model.uuid,
      active: true,
      state: this.state.model.state,
      onTabReady: this.onTabReady.bind(this)
    }), _react.default.createElement(_2.StatusStripe, {
      noHelp: this.props.noHelp,
      noSettings: this.props.noSettings
    }, _react.default.createElement(_2.ContextWidgets, {
      className: "kui--input-stripe-in-status-stripe"
    }, this.state.tab && _react.default.createElement(_InputStripe.default, {
      ref: this._inputStripeRef,
      promptPlaceholder: this.state.promptPlaceholder,
      uuid: this.state.model.uuid,
      tab: this.state.tab
    })), this.props.children));
  }

}

exports.default = Popup;