"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _reactCore = require("@patternfly/react-core");

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _Tooltip = _interopRequireDefault(require("../../spi/Tooltip"));

var _ctrlOrMeta = _interopRequireDefault(require("./ctrlOrMeta"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const Markdown = _react.default.lazy(() => Promise.resolve().then(() => require('../../Content/Markdown')));

const strings = (0, _core.i18n)('plugin-core-support');
const strings2 = (0, _core.i18n)('plugin-client-common');

class Tab extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.closeTabRef = _react.default.createRef();
    this.state = {
      title: props.title || strings('Tab'),
      processing: false,
      isFreshlyCreated: true,
      topTabNames: props.topTabNames || 'fixed'
    };

    if (!props.topTabNames) {
      setTimeout(() => __awaiter(this, void 0, void 0, function* () {
        const {
          theme
        } = yield (0, _core.findThemeByName)((yield (0, _core.getPersistedThemeChoice)()) || (yield (0, _core.getDefaultTheme)()));

        if (theme.topTabNames) {
          this.setState({
            topTabNames: theme.topTabNames
          });
        }
      }));
    }

    this.addCommandEvaluationListeners();
  }

  componentWillUnmount() {
    this.removeCommandEvaluationListeners();
  }

  removeCommandEvaluationListeners() {
    _core.eventBus.offCommandStart(this.props.uuid, this.onCommandStart);

    _core.eventBus.offCommandComplete(this.props.uuid, this.onCommandStart);

    _core.eventChannelUnsafe.off('/theme/change', this.onThemeChange);
  }
  /**
   * Register any command evaluation listeners, i.e. when the REPL finishes evaluating a command.
   *
   */


  addCommandEvaluationListeners() {
    this.onCommandComplete = event => {
      if (this.props.uuid === event.tab.state.uuid) {
        if (event.execType !== undefined && event.execType !== _core.ExecType.Nested && event.route) {
          // ignore nested, which means one plugin calling another
          this.setState({
            processing: false
          });
        }

        this.setState({
          processing: false
        });
      }
    };

    this.onCommandStart = event => {
      if (this.props.uuid === event.tab.state.uuid) {
        if (event.execType !== undefined && event.execType !== _core.ExecType.Nested && event.route) {
          // ignore nested, which means one plugin calling another
          // debug('got event', event)
          if (event.route !== undefined && !event.route.match(/^\/(tab|getting\/started)/) // ignore our own events and help
          ) {
              if (this.isUsingCommandName()) {
                this.setState({
                  processing: true,
                  title: event.command || this.state.title,
                  isFreshlyCreated: false
                });
                return;
              }
            }

          this.setState({
            processing: true,
            isFreshlyCreated: false
          });
        }
      }
    };

    this.onThemeChange = ({
      themeModel
    }) => {
      this.setState({
        topTabNames: themeModel.topTabNames || 'fixed'
      });
    };

    _core.eventBus.onCommandStart(this.props.uuid, this.onCommandStart);

    _core.eventBus.onCommandComplete(this.props.uuid, this.onCommandComplete);

    _core.eventChannelUnsafe.on('/theme/change', this.onThemeChange);
  }

  isUsingCommandName() {
    return this.state.topTabNames === 'command'; // && !document.body.classList.contains('kui--alternate')
  }

  render() {
    return _react.default.createElement(_reactCore.NavItem, {
      href: "#",
      "data-tab-names": this.state.topTabNames,
      "data-fresh": this.state.isFreshlyCreated,
      "data-custom-label": this.props.title ? true : undefined,
      "data-custom-label-text": this.props.title || undefined,
      isActive: this.props.active,
      styleChildren: false,
      className: 'kui--tab kui--tab-navigatable' + (this.props.active ? ' kui--tab--active' : '') + (this.state.processing ? ' processing' : ''),
      "data-tab-button-index": this.props.idx + 1,
      "aria-label": "tab",
      onMouseDown: evt => {
        evt.preventDefault();
        evt.stopPropagation();
      },
      onClick: () => {
        this.props.onSwitchTab(this.props.idx);
      }
    }, _react.default.createElement("div", {
      className: "kui--tab--label"
    }, this.isUsingCommandName() && this.state.title, !this.isUsingCommandName() && _react.default.createElement("span", {
      className: "kui--tab--label-text"
    }, this.props.title ? _react.default.createElement(_react.default.Suspense, {
      fallback: _react.default.createElement("div", null)
    }, _react.default.createElement(Markdown, {
      nested: true,
      source: this.props.title
    })) : strings('Tab'), ' '), !this.isUsingCommandName() && _react.default.createElement("span", {
      className: "kui--tab--label-index"
    })), this.props.closeable && _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("div", {
      className: "kui--tab-close",
      ref: this.closeTabRef,
      onClick: evt => {
        evt.stopPropagation();
        evt.preventDefault();
        this.props.onCloseTab(this.props.idx);
      }
    }, _react.default.createElement(_Icons.default, {
      icon: "WindowClose",
      focusable: "false",
      preserveAspectRatio: "xMidYMid meet",
      "aria-hidden": "true"
    })), _react.default.createElement(_Tooltip.default, {
      reference: this.closeTabRef,
      position: "bottom"
    }, strings2('Close this tab', (0, _ctrlOrMeta.default)('W')))));
  }

}

exports.default = Tab;