"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Tag = _interopRequireDefault(require("../../spi/Tag"));

var _HTMLDom = _interopRequireDefault(require("../../Content/Scalar/HTMLDom"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* function isHTMLImage(img: HTMLImageElement | SVGElement): img is HTMLImageElement {
  return (img as HTMLImageElement).alt !== undefined
} */
function oneTimeRender(badgeText) {
  if (typeof badgeText === 'string') {
    return _react.default.createElement(_react.default.Fragment, null, badgeText);
  } else if (badgeText instanceof Element) {
    return _react.default.createElement(_HTMLDom.default, {
      className: "badge-as-image",
      content: badgeText
    });
  } else {
    // otherwise, badge is an IBadgeSpec
    const className = (badgeText.css || '') + (badgeText.onclick ? ' clickable' : '');

    if (badgeText.image) {
      /* // badge is an HTMLImageElement
      if (isHTMLImage(badgeText.image)) {
        badgeText.image.alt = badgeText.title
      }
             return (
          <div data-tag="badge" className={className} ref={badgeText.image}>
          </div>
      )
      badge.appendChild()
      badge.classList.add('badge-as-image') */
      return _react.default.createElement("div", null);
    } else if (badgeText.fontawesome) {
      // badge is a named fontawesome icon
      return _react.default.createElement("div", null);
      /* const awesome = document.createElement('i')
      awesome.className = badgeText.fontawesome
      badge.classList.add('badge-as-fontawesome')
      badge.appendChild(awesome) */
    } else {
      const type = className === 'green-background' ? 'ok' : className === 'red-background' ? 'error' : 'warning';
      return _react.default.createElement("div", {
        className: className || 'gray-background',
        onClick: () => badgeText.onclick()
      }, _react.default.createElement(_Tag.default, {
        type: type
      }, badgeText.title));
    }
  }
}

class Badge extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      cache: oneTimeRender(typeof props.spec === 'function' ? props.spec(props.response, props.tab) : props.spec)
    };
  }

  render() {
    return this.state.cache;
  }

}

exports.default = Badge;