"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _Tooltip = _interopRequireDefault(require("../../spi/Tooltip"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

class ToolbarButton extends _react.default.PureComponent {
  constructor() {
    super(...arguments);
    this._buttonOnclick = this.buttonOnclick.bind(this);
  }

  getCommand() {
    const {
      tab,
      response,
      button,
      args
    } = this.props;

    if ((0, _core.isViewButton)(button)) {
      return button.command;
    } else {
      const cmd = typeof button.command === 'string' ? button.command : button.command(tab, response, args);

      if (button.confirm) {
        return `confirm "${cmd}"`;
      } else {
        return cmd;
      }
    }
  }

  buttonOnclick() {
    return __awaiter(this, void 0, void 0, function* () {
      const cmd = yield this.getCommand();
      const {
        tab,
        execUUID,
        response,
        button,
        args
      } = this.props;

      if (typeof cmd === 'string') {
        if ((0, _core.isViewButton)(button) || button.confirm) {
          return tab.REPL.qexec(cmd, undefined, undefined, {
            rethrowErrors: true
          });
        } else {
          if (button.inPlace) {
            return tab.REPL.reexec(cmd, {
              execUUID
            });
          } else {
            return tab.REPL.pexec(cmd);
          }
        }
      } else if (typeof cmd === 'function') {
        cmd(tab, response, args);
      } else {// e.g. this happens for kubectl edit on apply error, this is
        // because the error handling is captured by the
        // Editor/index.tsx
      }
    });
  }

  render() {
    const {
      button
    } = this.props;
    return _react.default.createElement(_Tooltip.default, {
      content: button.label || button.mode
    }, _react.default.createElement("span", {
      className: 'kui--tab-navigatable kui--notab-when-sidecar-hidden sidecar-bottom-stripe-button-as-button sidecar-bottom-stripe-button' + (button.icon ? ' kui--toolbar-button-with-icon' : '')
    }, _react.default.createElement("div", {
      role: "presentation",
      onClick: this._buttonOnclick,
      "data-mode": button.mode
    }, _react.default.createElement("span", {
      role: "tab"
    }, button.icon ? button.icon : button.label || button.mode))));
  }

}

exports.default = ToolbarButton;