"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _TwoFaceIcon = _interopRequireDefault(require("../../../spi/Icons/TwoFaceIcon"));

var _BlockModel = require("./BlockModel");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');

function Action(props) {
  return _react.default.createElement(_TwoFaceIcon.default, {
    a: props.icon,
    b: "Checkmark",
    onClick: props.onClick,
    classNameB: "green-text",
    className: "kui--block-action",
    title: strings(props.title)
  });
}

class Actions extends _react.default.PureComponent {
  rerunAction() {
    if ((0, _BlockModel.hasUUID)(this.props.model) && (0, _BlockModel.isRerunable)(this.props.model) && !(0, _BlockModel.isOutputOnly)(this.props.model) && this.props.tab && this.props.command) {
      const handler = () => {
        if ((0, _BlockModel.hasUUID)(this.props.model)) {
          this.props.tab.REPL.reexec(this.props.command, {
            execUUID: this.props.model.execUUID
          });
        }
      };

      return _react.default.createElement(Action, {
        icon: "Retry",
        onClick: handler,
        title: strings('Re-execute this command')
      });
    }
  }

  copyAction() {
    return this.props.command && _react.default.createElement(Action, {
      icon: "Copy",
      onClick: () => navigator.clipboard.writeText(this.props.command),
      title: "Copy the command line to the clipboard"
    });
  }

  removeAction() {
    return this.props.willRemove && _react.default.createElement(Action, {
      icon: "WindowClose",
      onClick: evt => this.props.willRemove(evt, this.props.idx),
      title: "Remove this block"
    });
  }
  /* private screenshotAction() {
    return (
      this.props.willScreenshot &&
      !inBrowser() && (
        <Action icon="Screenshot" onClick={() => this.props.willScreenshot()} title={strings2('Screenshot')} />
      )
    )
  } */

  /* private upwardAction() {
    return (
      this.props.hasBlockBefore &&
      this.props.willMoveUpward && (
        <Action icon="MoveUp" onClick={() => this.props.willMoveUpward()} title="Move this block up" />
      )
    )
  } */

  /* private downwardAction() {
    return (
      this.props.hasBlockAfter &&
      this.props.willMoveDownward && (
        <Action icon="MoveDown" onClick={() => this.props.willMoveDownward()} title="Move this block down" />
      )
    )
  } */


  render() {
    return !(0, _core.isOfflineClient)() && _react.default.createElement("div", {
      className: "kui--block-actions-buttons kui--inverted-color-context"
    }, _react.default.createElement("div", {
      className: "kui-block-actions-others"
    }, this.copyAction(), this.rerunAction()), this.removeAction());
  }

}

exports.default = Actions;