"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PatternFly4Icons;

var _react = _interopRequireDefault(require("react"));

var _reactIcons = require("@patternfly/react-icons");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const size20 = {
  fontSize: '1rem'
};
const size32 = {
  fontSize: '32px',
  padding: '3px'
};
const Sidecar = {
  fontSize: '1.125em'
};
const StatusStripe = Sidecar;
const Pagination = {
  fontSize: '1.5em'
};
/** helper to ensure exhaustiveness of the switch statement below */
// eslint-disable-next-line @typescript-eslint/no-unused-vars

function assertUnreachable(x) {
  throw new Error('Did not expect to get here');
}

function PatternFly4Icons(props) {
  switch (props.icon) {
    case 'At':
      return _react.default.createElement(_reactIcons.AtIcon, Object.assign({
        style: StatusStripe
      }, props));

    case 'Add':
      return _react.default.createElement(_reactIcons.PlusIcon, Object.assign({
        style: size20
      }, props));

    case 'Back':
      return _react.default.createElement(_reactIcons.ArrowLeftIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'ChartBar':
      return _react.default.createElement(_reactIcons.ChartBarIcon, Object.assign({}, props));

    case 'Checkmark':
      return _react.default.createElement(_reactIcons.CheckCircleIcon, Object.assign({}, props));

    case 'CodeBranch':
      return _react.default.createElement(_reactIcons.CodeBranchIcon, Object.assign({
        style: StatusStripe
      }, props));

    case 'Copy':
      return _react.default.createElement(_reactIcons.CopyIcon, Object.assign({}, props));

    case 'Edit':
      return _react.default.createElement(_reactIcons.EditIcon, Object.assign({}, props));

    case 'Clear':
      return _react.default.createElement(_reactIcons.EraserIcon, Object.assign({}, props));

    case 'Error':
      return _react.default.createElement(_reactIcons.BombIcon, Object.assign({}, props));

    case 'Eye':
      return _react.default.createElement(_reactIcons.EyeIcon, Object.assign({}, props));

    case 'EyeSlash':
      return _react.default.createElement(_reactIcons.EyeSlashIcon, Object.assign({}, props));

    case 'Forward':
      return _react.default.createElement(_reactIcons.ArrowRightIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'Grid':
      return _react.default.createElement(_reactIcons.ThIcon, Object.assign({}, props));

    case 'Github':
      return _react.default.createElement(_reactIcons.GithubIcon, Object.assign({}, props));

    case 'Help':
      return _react.default.createElement(_reactIcons.QuestionCircleIcon, Object.assign({
        style: size20
      }, props));

    case 'Info':
      return _react.default.createElement(_reactIcons.InfoCircleIcon, Object.assign({}, props));

    case 'List':
      return _react.default.createElement(_reactIcons.ListIcon, Object.assign({}, props));

    case 'Location':
      return _react.default.createElement(_reactIcons.MapMarkerAltIcon, Object.assign({}, props));

    case 'MoveUp':
      return _react.default.createElement(_reactIcons.ArrowUpIcon, Object.assign({}, props));

    case 'MoveDown':
      return _react.default.createElement(_reactIcons.ArrowDownIcon, Object.assign({}, props));

    case 'Pause':
      return _react.default.createElement(_reactIcons.PauseCircleIcon, Object.assign({}, props));

    case 'Play':
      return _react.default.createElement(_reactIcons.PlayCircleIcon, Object.assign({}, props));

    case 'PreviousPage':
      return _react.default.createElement(_reactIcons.CaretLeftIcon, Object.assign({
        style: Pagination
      }, props));

    case 'Retry':
      return _react.default.createElement(_reactIcons.RebootingIcon, Object.assign({}, props));

    case 'Revert':
      return _react.default.createElement(_reactIcons.HistoryIcon, Object.assign({}, props));

    case 'Save':
      return _react.default.createElement(_reactIcons.SaveIcon, Object.assign({}, props));

    case 'Network':
      return _react.default.createElement(_reactIcons.NetworkWiredIcon, Object.assign({}, props));

    case 'NextPage':
      return _react.default.createElement(_reactIcons.CaretRightIcon, Object.assign({
        style: Pagination
      }, props));

    case 'Notification':
      return _react.default.createElement(_reactIcons.BellIcon, Object.assign({}, props));

    case 'Server':
      return _react.default.createElement(_reactIcons.ServerIcon, Object.assign({}, props));

    case 'Settings':
      return _react.default.createElement(_reactIcons.SlidersHIcon, Object.assign({
        style: size20
      }, props));

    case 'Sequence':
      return _react.default.createElement(_reactIcons.SlidersHIcon, Object.assign({}, props));

    case 'Screenshot':
      return _react.default.createElement(_reactIcons.CameraIcon, Object.assign({}, props));

    case 'ScreenshotInProgress':
      return _react.default.createElement(_reactIcons.CameraRetroIcon, Object.assign({}, props));

    case 'Split':
      return _react.default.createElement(_reactIcons.ColumnsIcon, Object.assign({
        style: size20
      }, props));

    case 'Search':
      return _react.default.createElement(_reactIcons.SearchIcon, Object.assign({
        style: size20
      }, props));

    case 'Trash':
      return _react.default.createElement(_reactIcons.TrashAltIcon, Object.assign({}, props));

    case 'TerminalOnly':
      return _react.default.createElement(_reactIcons.OutlinedWindowMaximizeIcon, Object.assign({
        style: size32
      }, props));

    case 'Theme':
      return _react.default.createElement(_reactIcons.PaletteIcon, Object.assign({}, props));

    case 'Warning':
      return _react.default.createElement(_reactIcons.ExclamationTriangleIcon, Object.assign({}, props));

    case 'Up':
      return _react.default.createElement(_reactIcons.LevelUpAltIcon, Object.assign({}, props));

    case 'WindowClose':
      return _react.default.createElement(_reactIcons.TimesIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'WindowMaximize':
      return _react.default.createElement(_reactIcons.ExpandIcon, Object.assign({
        style: Sidecar
      }, props));

    case 'WindowMinimize':
      return _react.default.createElement(_reactIcons.CompressIcon, Object.assign({
        style: Sidecar
      }, props));
  } // this bit of magic ensures exhaustiveness of the switch;
  // reference: https://stackoverflow.com/a/39419171


  return assertUnreachable(props.icon);
}