"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PatternFlyTooltip;

var _react = _interopRequireDefault(require("react"));

var _model = require("../model");

var _Markdown = _interopRequireDefault(require("../../../Content/Markdown"));

var _reactCore = require("@patternfly/react-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function PatternFlyTooltip(props) {
  const isMarkdown = (0, _model.isMarkdownProps)(props);
  return _react.default.createElement(_reactCore.Tooltip, {
    className: "kui--tooltip",
    isContentLeftAligned: isMarkdown,
    position: props.position || 'auto',
    entryDelay: props.entryDelay || 200,
    "data-is-markdown": isMarkdown || undefined,
    reference: (0, _model.isReferenceProps)(props) && props.reference,
    content: (0, _model.isReferenceProps)(props) ? props.children : (0, _model.isMarkdownProps)(props) ? _react.default.createElement(_Markdown.default, {
      nested: true,
      source: props.markdown
    }) : props.content
  }, !(0, _model.isReferenceProps)(props) && _react.default.createElement(_react.default.Fragment, null, props.children));
}