"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debug = debug;
exports.default = split;

var _core = require("@kui-shell/core");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');
/** For debugging, this returns the tab uuid of the current split */

function debug(args) {
  return args.tab.uuid;
}
/**
 * This plugin introduces the /split command
 *
 */


function split(args) {
  const options = {
    if: args.parsedOptions.if,
    ifnot: args.parsedOptions.ifnot,
    index: args.parsedOptions.index,
    cmdline: args.parsedOptions.cmdline,
    inverseColors: args.parsedOptions.inverse
  };
  return {
    apiVersion: 'kui-shell/v1',
    kind: 'TabLayoutModificationResponse',
    spec: {
      modification: 'NewSplit',
      options,
      ok: {
        content: strings(args.parsedOptions.inverse ? 'Created a split with inverted colors' : 'Created a split'),
        contentType: 'text/markdown'
      }
    }
  };
}