import React, { PropsWithChildren } from 'react';
import { Tab as KuiTab } from '@kui-shell/core';
import KuiConfiguration from './KuiConfiguration';
import { InputOptions } from '../Views/Terminal/Block/Input';
import BlockModel from '../Views/Terminal/Block/BlockModel';
import '../../../web/css/static/InputStripe.scss';
declare type Props = PropsWithChildren<Partial<KuiConfiguration> & InputOptions & {
    tab?: KuiTab;
    /** tab uuid; this is grafted in for you, by TabContent */
    uuid?: string;
}>;
interface State {
    idx: number;
    model: BlockModel;
}
export default class InputStripe extends React.PureComponent<Props, State> {
    private _blockRef;
    constructor(props: Props);
    /** Command has completed in our tab */
    private onOutputRender;
    doFocus(): void;
    render(): JSX.Element;
}
export {};
