/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME:
/* eslint-disable react/prop-types */
import React from 'react';
import { eventBus, pexecInCurrentTab, i18n } from '@kui-shell/core';
import Settings from './Settings';
import Icons from '../../spi/Icons';
import Tooltip from '../../spi/Tooltip';
import MeterWidgets from './MeterWidgets';
const Markdown = React.lazy(() => import('../../Content/Markdown'));
import '../../../../web/scss/components/StatusStripe/StatusStripe.scss';
const strings = i18n('plugin-client-common');
/** see https://github.com/microsoft/TypeScript/issues/10485 */
function hasType(evt) {
    return evt.type !== undefined;
}
export default class StatusStripe extends React.PureComponent {
    constructor(props) {
        super(props);
        this.helpRef = React.createRef();
        eventBus.onStatusStripeChangeRequest(this.onChangeRequest.bind(this));
        this.state = this.withStateDefaults(props);
    }
    /** Overlay default values for required state variables */
    withStateDefaults(evt) {
        if (hasType(evt)) {
            return evt;
        }
        else {
            return Object.assign({}, evt, { type: 'default' });
        }
    }
    /** Status Stripe change request */
    onChangeRequest(evt) {
        this.setState(this.withStateDefaults(evt));
    }
    /**
     * User has clicked on the Settings icon.
     *
     */
    doAbout() {
        return __awaiter(this, void 0, void 0, function* () {
            pexecInCurrentTab('about');
        });
    }
    /**
     * If the Client offers no status stripe widgets, we should insert a
     * filler, so that the Settings icon is presented flush-right.
     *
     */
    filler() {
        return React.createElement("div", { style: { flex: 1 } });
    }
    /**
     * Render the current State.message, if any
     *
     */
    message() {
        if (this.state.type !== 'default' && this.state.message) {
            return (React.createElement("div", { className: "kui--status-stripe-element left-pad kui--status-stripe-message-element" },
                React.createElement(Markdown, { source: this.state.message })));
        }
    }
    /**
     * Render any widgets specified by the client. Note how we don't
     * show widgets if we were given a message. See
     * https://github.com/IBM/kui/issues/5490
     *
     */
    widgets() {
        if (this.state.type !== 'default' || React.Children.count(this.props.children) === 0) {
            return this.filler();
        }
        else {
            return this.props.children;
        }
    }
    className() {
        return 'kui--status-stripe' + (this.state.type === 'default' ? ' kui--inverted-color-context' : '');
    }
    render() {
        return (React.createElement(React.Suspense, { fallback: React.createElement("div", null) },
            React.createElement("div", { className: this.className(), id: "kui--status-stripe", "data-type": this.state.type },
                this.message(),
                this.widgets(),
                React.createElement(MeterWidgets, { className: "kui--hide-in-narrower-windows" }, !this.props.noSettings && React.createElement(Settings, null)),
                !this.props.noHelp && (React.createElement("div", { className: "kui--status-stripe-button" },
                    React.createElement("a", { href: "#", className: "kui--tab-navigatable kui--status-stripe-element-clickable kui--status-stripe-element", id: "help-button", "aria-label": "Help", tabIndex: 0, ref: this.helpRef, onClick: () => this.doAbout() },
                        React.createElement(Icons, { icon: "Help" })),
                    React.createElement(Tooltip, { reference: this.helpRef, position: "top" }, strings('Click for help')))))));
    }
}
//# sourceMappingURL=index.js.map