/// <reference types="react" />
/// <reference types="node" />
import { NewTabRequestEvent, StatusStripeChangeEvent, TabState } from '@kui-shell/core';
export declare function uuid(): string;
export interface TopTabButton<P extends {
    key: string;
} = {
    key: string;
}> {
    icon: React.ReactElement<P>;
}
export default class TabModel {
    private readonly _uuid;
    private readonly desiredStatusStripeDecoration?;
    private readonly _title?;
    private readonly _state;
    private readonly _buttons;
    private readonly _initialCommandLine?;
    private readonly _onClose?;
    private readonly _exec?;
    private readonly _snapshot?;
    constructor(_uuid?: string, desiredStatusStripeDecoration?: StatusStripeChangeEvent, background?: boolean, _title?: string, _state?: TabState, _buttons?: TopTabButton[], _initialCommandLine?: string, _onClose?: string, _exec?: NewTabRequestEvent['exec'], _snapshot?: Buffer);
    get uuid(): string;
    get state(): TabState;
    get buttons(): TopTabButton<{
        key: string;
    }>[];
    get title(): string;
    get initialCommandLine(): string;
    get onClose(): string;
    get exec(): "pexec" | "qexec";
    get snapshot(): Buffer;
    update(buttons: TopTabButton[]): TabModel;
}
