import React from 'react';
import { editor as Monaco } from 'monaco-editor';
import { Options as MonacoOptions } from './lib/defaults';
import '../../../../web/scss/components/Editor/Editor.scss';
declare type Props = Pick<MonacoOptions, 'fontSize'> & {
    tabUUID: string;
    content: string;
    contentType: string;
    simple?: boolean;
    className?: string;
    readonly?: boolean;
    onContentChange?: (content: string) => void;
    scrollIntoView?: boolean;
    /** Minimum height of the editor */
    minHeight?: number;
    /** Use a light theme? Default: false */
    light?: boolean;
    /** Callback when user hits cmd/ctrl+S or shift-return */
    onSave?: (content: string) => void;
    /** Callback when user hits Escape */
    onCancel?: (content: string) => void;
};
interface State {
    editor: ReturnType<typeof Monaco.create>;
    wrapper: React.RefObject<HTMLDivElement>;
    catastrophicError: Error;
    cleaners: (() => void)[];
}
export default class SimpleEditor extends React.Component<Props, State> {
    constructor(props: Props);
    static getDerivedStateFromError(error: Error): {
        catastrophicError: Error;
    };
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    shouldComponentUpdate(nextProps: Props, nextState: State): boolean;
    /** Called whenever we have proposed (props,state); we derive a new State */
    static getDerivedStateFromProps(props: Props, state: State): State;
    /** Called when this component is no longer attached to the document */
    componentWillUnmount(): void;
    /** Called when we no longer need the monaco-editor instance */
    private destroyMonaco;
    /** When content of the editor changes, call `onContentChange`  */
    private static onChange;
    /** Register onSave and onCancel keyboard shortcuts */
    private registerKeyboardShortcuts;
    /** Called when we have a ready wrapper (monaco's init requires an wrapper */
    private initMonaco;
    componentDidMount(): void;
    render(): JSX.Element;
}
export {};
