import React from 'react';
import { Table as KuiTable, Cell as KuiCell, Row as KuiRow, Tab, REPL } from '@kui-shell/core';
export declare type CellOnClickHandler = (evt: React.MouseEvent) => void;
/**
 * Generate an onclick handler for a cell
 *
 */
export declare function onClickForCell(row: KuiRow, tab: Tab, repl: REPL, cell?: KuiCell, opts?: Pick<KuiTable, 'drilldownTo'> & {
    selectRow?: () => void;
}): CellOnClickHandler;
/**
 * Render a TableCell part
 *
 */
export default function renderCell(table: KuiTable, kuiRow: KuiRow, justUpdated: boolean, tab: Tab, repl: REPL): (key: string, value: string, tag: string, outerCSS: string, css: string, onclick: KuiRow['onclick'], cidx: number) => JSX.Element;
