/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
const Markdown = React.lazy(() => import('../Markdown'));
import Icons from '../../spi/Icons';
import Breadcrumb from '../../spi/Breadcrumb';
import '../../../../web/css/static/ToolbarButton.scss';
import '../../../../web/scss/components/Table/Events.scss';
import '../../../../web/scss/components/Table/Toolbar.scss';
export default class Toolbar extends React.PureComponent {
    hasGridButtons() {
        return this.props.gridableColumn !== undefined && this.props.gridableColumn >= 0;
    }
    hasButtons() {
        return this.hasGridButtons() || this.props.hasSequenceButton || this.props.hasHistogramButton;
    }
    viewController() {
        if (this.hasGridButtons() || this.props.hasSequenceButton || this.props.hasHistogramButton) {
            return (React.createElement(React.Fragment, null,
                React.createElement("a", { role: "presentation", href: "#", className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-list", "data-enabled": !this.props.asGrid && !this.props.asSequence && !this.props.asTimeline && !this.props.asHistogram, onClick: () => {
                        this.props.setAsGrid(false);
                        this.props.setAsSequence(false);
                        this.props.setAsTimeline(false);
                        this.props.setAsHistogram(false);
                    } },
                    React.createElement(Icons, { icon: "List" })),
                this.hasGridButtons() && (React.createElement("a", { role: "presentation", href: "#", className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-grid", "data-enabled": this.props.asGrid, onClick: () => {
                        this.props.setAsSequence(false);
                        this.props.setAsGrid(true);
                        this.props.setAsTimeline(false);
                    } },
                    React.createElement(Icons, { icon: "Grid" }))),
                this.props.hasSequenceButton && (React.createElement("a", { role: "presentation", href: "#", className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-sequence", "data-enabled": this.props.asSequence, onClick: () => {
                        this.props.setAsGrid(false);
                        this.props.setAsSequence(true);
                        this.props.setAsTimeline(false);
                    } },
                    React.createElement(Icons, { icon: "Sequence" }))),
                this.props.hasHistogramButton && (React.createElement("a", { role: "presentation", href: "#", className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-histogram", "data-enabled": this.props.asHistogram, onClick: () => {
                        this.props.setAsGrid(false);
                        this.props.setAsSequence(false);
                        this.props.setAsHistogram(true);
                        this.props.setAsTimeline(false);
                    } },
                    React.createElement(Icons, { icon: "ChartBar" }))),
                this.props.hasTimelineButton && (React.createElement("a", { role: "presentation", href: "#", className: "kui--table-navigatable kui--toolbar-button-with-icon kui--toolbar-button-as-timeline", "data-enabled": this.props.asTimeline, onClick: () => {
                        this.props.setAsGrid(false);
                        this.props.setAsSequence(false);
                        this.props.setAsTimeline(true);
                    } },
                    React.createElement(Icons, { icon: "ChartBar" })))));
        }
    }
    previousPage() {
        this.props.setPage(this.props.page - 1);
    }
    nextPage() {
        this.props.setPage(this.props.page + 1);
    }
    paginationController() {
        if (this.props.paginate) {
            const start = (this.props.page - 1) * this.props.pageSize + 1;
            const end = this.props.page * this.props.pageSize;
            const isFirstPage = this.props.page === 1;
            const nPages = Math.ceil(this.props.totalItems / this.props.pageSize);
            const isLastPage = this.props.page === nPages;
            const maxLength = end.toString().length;
            const rangeText = `${start.toString().padStart(maxLength)} \u2014 ${end} of ${this.props.totalItems}`;
            return (React.createElement("div", { className: "kui--data-table-toolbar-pagination bx--pagination" },
                React.createElement("span", { className: "kui--data-table-toolbar-pagination-info" }, rangeText),
                React.createElement("button", { type: "button", onMouseDown: evt => evt.preventDefault(), disabled: isFirstPage, className: 'bx--pagination__button bx--pagination__button--backward' +
                        (isFirstPage ? ' bx--pagination__button--no-index' : ''), "aria-label": "Previous page", onClick: () => this.previousPage() },
                    React.createElement(Icons, { icon: "PreviousPage" })),
                React.createElement("button", { type: "button", onMouseDown: evt => evt.preventDefault(), disabled: isLastPage, className: 'bx--pagination__button bx--pagination__button--forward' +
                        (isLastPage ? ' bx--pagination__button--no-index' : ''), "aria-label": "Next page", onClick: () => this.nextPage() },
                    React.createElement(Icons, { icon: "NextPage" }))));
        }
    }
    breadcrumbs() {
        if (this.props.breadcrumbs) {
            return React.createElement(Breadcrumb, { breadcrumbs: this.props.breadcrumbs, repl: this.props.repl });
        }
    }
    buttons() {
        if (this.hasButtons()) {
            return React.createElement("div", { className: "kui--data-table-toolbar-buttons" }, this.viewController());
        }
    }
    /** so that buttons are flush-left and pagination is flush-right */
    filler() {
        return React.createElement("div", { className: "kui--data-table-toolbar-filler" });
    }
    messageStream() {
        if (this.props.stream) {
            return this.props.stream.map((_, idx) => (React.createElement("div", { key: `${_}-${idx}`, className: "kui--data-table-footer-messages kui--inverted-color-context" },
                React.createElement("div", { className: "kui--data-table-footer-message" },
                    React.createElement(Markdown, { source: _, noExternalLinks: true, repl: this.props.repl })))));
        }
    }
    caption() {
        return (this.props.caption && (React.createElement("div", { className: "kui--table-caption flex-layout even-smaller-text sub-text" }, this.props.caption)));
    }
    render() {
        const className = 'kui--data-table-toolbar' + (this.props.className ? ` ${this.props.className}` : '');
        return (React.createElement("div", { className: className, "data-frame": this.props.framed || undefined },
            this.breadcrumbs(),
            this.buttons(),
            this.props.children,
            this.filler(),
            this.caption(),
            this.messageStream(),
            this.paginationController()));
    }
}
//# sourceMappingURL=Toolbar.js.map