import React from 'react';
import { REPL } from '@kui-shell/core';
import Width from './width';
import { BreadcrumbView } from '../../spi/Breadcrumb';
export interface Props {
    kind?: string;
    name?: string;
    namespace?: string;
    breadcrumbs?: BreadcrumbView[];
    /** Is this sidecar not closeable? */
    notCloseable?: boolean;
    repl: REPL;
    width: Width;
    onClickNamespace?: () => void;
    onClose: () => void;
    back?: {
        enabled: boolean;
        onClick: () => void;
    };
    forward?: {
        enabled?: boolean;
        onClick: () => void;
    };
}
/**
 * TitleBar
 * ---------------------------------
 * | Kind | Namespace    S | M m x |
 * ---------------------------------
 *
 *  Kind: props.kind
 *  Namespace: props.namespace
 */
export default class Window extends React.PureComponent<Props> {
    private quitButton;
    /** back button */
    private back;
    /** forward button */
    private forward;
    /** render history navigation UI */
    private history;
    render(): JSX.Element;
}
