import React from 'react';
import { Tab as KuiTab, Stream } from '@kui-shell/core';
import { BlockViewTraits, BlockOperationTraits } from './';
import { ProcessingBlock, FinishedBlock } from './BlockModel';
import { Maximizable } from '../../Sidecar/width';
declare type Props = {
    /** tab UUID */
    uuid: string;
    /** for key handlers, which may go away soon */
    tab: KuiTab;
    /** Block ordinal */
    idx: number;
    /** Block ordinal to be displayed to user */
    displayedIdx?: number;
    /** Are we in the middle of a re-run? */
    isBeingRerun: boolean;
    model: ProcessingBlock | FinishedBlock;
    onRender: () => void;
    willUpdateCommand?: (idx: number, command: string) => void;
} & Maximizable & BlockViewTraits & BlockOperationTraits;
interface State {
    alreadyListen: boolean;
    assertHasContent?: boolean;
    isResultRendered: boolean;
    nStreamingOutputs: number;
    streamingConsumer: Stream;
}
export default class Output extends React.PureComponent<Props, State> {
    private readonly _willRemove;
    private readonly _willUpdateCommand;
    private streamingOutput;
    constructor(props: Props);
    private streamingConsumer;
    static getDerivedStateFromProps(props: Props, state: State): State | {
        alreadyListen: boolean;
        isResultRendered: boolean;
        streamingOutput: any[];
    } | {
        alreadyListen: boolean;
        isResultRendered: boolean;
        streamingOutput?: undefined;
    };
    private onRender;
    private readonly _onRender;
    private hasStreamingOutput;
    private outputWillOverflow;
    private stream;
    private result;
    private cursor;
    private isShowingSomethingInTerminal;
    private ok;
    private ctx;
    /** For output-only blocks, render the Block Actions */
    private actions;
    render(): JSX.Element;
}
export {};
