/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import Icons from '.';
export default class TwoFaceIcon extends React.PureComponent {
    constructor(props) {
        super(props);
        this.toggle = this.onToggle.bind(this);
        this.state = {
            face: 'a'
        };
    }
    toggleState() {
        this.setState(curState => ({ face: curState.face === 'a' ? 'b' : 'a' }));
    }
    onToggle(evt) {
        evt.stopPropagation();
        this.toggleState();
        setTimeout(() => this.toggleState(), this.props.delay || 1500);
        if (this.props.onClick) {
            this.props.onClick(evt);
        }
    }
    render() {
        return (React.createElement("a", { href: "#", onClick: this.toggle, title: this.props.title, className: (this.props.className || '') +
                ' ' +
                (this.state.face === 'b' && this.props.classNameB ? this.props.classNameB : '') },
            React.createElement(Icons, { icon: this.state.face === 'a' ? this.props.a : this.props.b })));
    }
}
//# sourceMappingURL=TwoFaceIcon.js.map