import { Button, Link, MultiModalMode, NavResponse, Tab } from '@kui-shell/core';
import { BaseHistoryEntry } from '../../Views/util/CircularBuffer';
interface Nav {
    title: string;
    currentTabIndex: number;
    tabs: MultiModalMode[];
    buttons?: Button[];
}
export interface Model {
    current: {
        menuIdx: number;
        tabIdx: number;
    };
    allNavs: Nav[];
    allLinks: Link[];
    response: NavResponse;
}
export declare type HistoryEntry = Model & BaseHistoryEntry & {
    execUUID: string;
};
interface Props<M extends Model = Model> {
    tab: Tab;
    current: M;
    changeCurrent: (menuIdx: number, tabIdx: number) => void;
}
export default Props;
