/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { i18n } from '@kui-shell/core';
import { get, reset, set, unset } from '../components/Client/UserSettings';
const strings = i18n('plugin-client-common/user-settings');
const settings = ['prompt', '_for_testing_'];
/**
 * This plugin introduces the /card command
 *
 */
export default (registrar) => __awaiter(void 0, void 0, void 0, function* () {
    /** Remove all user setting overrides */
    registrar.listen('/kuiconfig/reset', () => __awaiter(void 0, void 0, void 0, function* () {
        yield reset();
        return true;
    }));
    settings.forEach(setting => {
        /** Read out a given user setting override */
        registrar.listen(`/kuiconfig/get/${setting}`, () => __awaiter(void 0, void 0, void 0, function* () {
            const value = yield get(setting);
            if (!value) {
                const error = new Error(strings('You have not specified a value for this setting'));
                error.code = 404;
                throw error;
            }
            else if (typeof value === 'string' || typeof value === 'boolean' || typeof value === 'number') {
                return value;
            }
            else {
                return value.toString();
            }
        }));
        /** Update a given user setting override */
        registrar.listen(`/kuiconfig/set/${setting}`, (args) => __awaiter(void 0, void 0, void 0, function* () {
            yield set(setting, args.argvNoOptions[3]);
            return true;
        }));
        /** Does the given setting have a value? */
        registrar.listen(`/kuiconfig/is/set/${setting}`, () => __awaiter(void 0, void 0, void 0, function* () {
            const value = yield get(setting);
            return value !== undefined;
        }));
        /** Does the given setting not have a value? */
        registrar.listen(`/kuiconfig/not/set/${setting}`, () => __awaiter(void 0, void 0, void 0, function* () {
            const value = yield get(setting);
            return value === undefined;
        }));
        /** Remove a given user setting override */
        registrar.listen(`/kuiconfig/unset/${setting}`, () => __awaiter(void 0, void 0, void 0, function* () {
            yield unset(setting);
            return true;
        }));
    });
});
//# sourceMappingURL=user-settings.js.map