"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = htmlLoader;

var _loaderUtils = require("loader-utils");

var _schemaUtils = _interopRequireDefault(require("schema-utils"));

var _plugins = require("./plugins");

var _utils = require("./utils");

var _options = _interopRequireDefault(require("./options.json"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

async function htmlLoader(content) {
  const options = (0, _loaderUtils.getOptions)(this);
  (0, _schemaUtils.default)(_options.default, options, {
    name: 'HTML Loader',
    baseDataPath: 'options'
  });

  if (options.preprocessor) {
    // eslint-disable-next-line no-param-reassign
    content = await options.preprocessor(content, this);
  }

  const plugins = [];
  const attributes = typeof options.attributes === 'undefined' ? true : options.attributes;

  if (attributes) {
    plugins.push((0, _plugins.sourcePlugin)({
      attributes,
      resourcePath: this.resourcePath
    }));
  }

  const minimize = typeof options.minimize === 'undefined' ? (0, _utils.isProductionMode)(this) : options.minimize;

  if (minimize) {
    plugins.push((0, _plugins.minimizerPlugin)({
      minimize
    }));
  }

  const {
    html,
    messages
  } = (0, _utils.pluginRunner)(plugins).process(content);
  const errors = [];
  const importedMessages = [];
  const replaceableMessages = [];
  const exportedMessages = [];

  for (const message of messages) {
    // eslint-disable-next-line default-case
    switch (message.type) {
      case 'error':
        errors.push(message.value);
        break;

      case 'import':
        importedMessages.push(message.value);
        break;

      case 'replacer':
        replaceableMessages.push(message.value);
        break;
    }
  }

  for (const error of errors) {
    this.emitError(error instanceof Error ? error : new Error(error));
  }

  const codeOptions = { ...options,
    loaderContext: this
  };
  const importCode = (0, _utils.getImportCode)(html, importedMessages, codeOptions);
  const moduleCode = (0, _utils.getModuleCode)(html, replaceableMessages, codeOptions);
  const exportCode = (0, _utils.getExportCode)(html, exportedMessages, codeOptions);
  let code = `${importCode}${moduleCode}${exportCode}`;

  if (options.process && options.process.post) {
    // eslint-disable-next-line no-param-reassign
    code = options.process.post(code, this);
  }

  return code;
}