"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pluginRunner = pluginRunner;
exports.getFilter = getFilter;
exports.isProductionMode = isProductionMode;
exports.getImportCode = getImportCode;
exports.getModuleCode = getModuleCode;
exports.getExportCode = getExportCode;

var _loaderUtils = require("loader-utils");

const GET_SOURCE_FROM_IMPORT_NAME = '___HTML_LOADER_GET_SOURCE_FROM_IMPORT___';

function pluginRunner(plugins) {
  return {
    process: content => {
      const result = {
        messages: []
      };

      for (const plugin of plugins) {
        // eslint-disable-next-line no-param-reassign
        content = plugin(content, result);
      }

      result.html = content;
      return result;
    }
  };
}

function getFilter(filter, defaultFilter = null) {
  return (attribute, value, resourcePath) => {
    if (defaultFilter && !defaultFilter(value)) {
      return false;
    }

    if (typeof filter === 'function') {
      return filter(attribute, value, resourcePath);
    }

    return true;
  };
}

function isProductionMode(loaderContext) {
  return loaderContext.mode === 'production' || !loaderContext.mode;
}

function getImportCode(html, importedMessages, codeOptions) {
  if (importedMessages.length === 0) {
    return '';
  }

  const {
    loaderContext,
    esModule
  } = codeOptions;
  const stringifiedHelperRequest = (0, _loaderUtils.stringifyRequest)(loaderContext, require.resolve('./runtime/getUrl.js'));
  let code = esModule ? `import ${GET_SOURCE_FROM_IMPORT_NAME} from ${stringifiedHelperRequest};\n` : `var ${GET_SOURCE_FROM_IMPORT_NAME} = require(${stringifiedHelperRequest});\n`;

  for (const item of importedMessages) {
    const {
      importName,
      source
    } = item;
    const stringifiedSourceRequest = (0, _loaderUtils.stringifyRequest)(loaderContext, source);
    code += esModule ? `import ${importName} from ${stringifiedSourceRequest};\n` : `var ${importName} = require(${stringifiedSourceRequest});\n`;
  }

  return `// Imports\n${code}`;
}

function getModuleCode(html, replaceableMessages) {
  let code = JSON.stringify(html) // Invalid in JavaScript but valid HTML
  .replace(/[\u2028\u2029]/g, str => str === '\u2029' ? '\\u2029' : '\\u2028');
  let replacersCode = '';

  for (const item of replaceableMessages) {
    const {
      importName,
      replacerName,
      unquoted,
      hash
    } = item;
    const getUrlOptions = [].concat(hash ? [`hash: ${JSON.stringify(hash)}`] : []).concat(unquoted ? 'maybeNeedQuotes: true' : []);
    const preparedOptions = getUrlOptions.length > 0 ? `, { ${getUrlOptions.join(', ')} }` : '';
    replacersCode += `var ${replacerName} = ${GET_SOURCE_FROM_IMPORT_NAME}(${importName}${preparedOptions});\n`;
    code = code.replace(new RegExp(replacerName, 'g'), () => `" + ${replacerName} + "`);
  }

  return `// Module\n${replacersCode}var code = ${code};\n`;
}

function getExportCode(html, exportedMessages, codeOptions) {
  if (codeOptions.esModule) {
    return `// Exports\nexport default code;`;
  }

  return `// Exports\nmodule.exports = code;`;
}