/// <reference types="node" />
import { CodedError, REPL } from '@kui-shell/core';
import URLFormatter from './url';
import { Status } from '../../../lib/model/resource';
import { FetchedFile, ReturnedError } from '../../../lib/util/fetch-file';
declare type WithErrors = {
    errors: CodedError[];
    ok: (string | Buffer | object)[];
    okIndices: number[];
    errorIndices: number[];
};
/** See if the given error message is a Kubernetes Status object */
export declare function tryParseAsStatus(code: number | string, error: string): ReturnedError | Status;
export default function handleErrors(responses: FetchedFile[], formatUrl: URLFormatter, kind: string, repl: REPL, returnErrors?: boolean): Promise<WithErrors>;
export {};
