var _excluded = ["accept", "buttonKind", "className", "disabled", "disableLabelChanges", "id", "labelText", "multiple", "onChange", "role", "name", "size", "tabIndex"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useRef, useState } from 'react';
import { matches, keys } from '../../internal/keyboard';
import { ButtonKinds } from '../../prop-types/types';
import uid from '../../tools/uniqueId';
import { usePrefix } from '../../internal/usePrefix';

function noop() {}

function FileUploaderButton(_ref) {
  var _cx;

  var accept = _ref.accept,
      _ref$buttonKind = _ref.buttonKind,
      buttonKind = _ref$buttonKind === void 0 ? 'primary' : _ref$buttonKind,
      className = _ref.className,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$disableLabelChan = _ref.disableLabelChanges,
      disableLabelChanges = _ref$disableLabelChan === void 0 ? false : _ref$disableLabelChan,
      id = _ref.id,
      _ref$labelText = _ref.labelText,
      ownerLabelText = _ref$labelText === void 0 ? 'Add file' : _ref$labelText,
      _ref$multiple = _ref.multiple,
      multiple = _ref$multiple === void 0 ? false : _ref$multiple,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? noop : _ref$onChange,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'button' : _ref$role,
      name = _ref.name,
      size = _ref.size,
      _ref$tabIndex = _ref.tabIndex,
      tabIndex = _ref$tabIndex === void 0 ? 0 : _ref$tabIndex,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();

  var _useState = useState(ownerLabelText),
      _useState2 = _slicedToArray(_useState, 2),
      labelText = _useState2[0],
      setLabelText = _useState2[1];

  var _useState3 = useState(ownerLabelText),
      _useState4 = _slicedToArray(_useState3, 2),
      prevOwnerLabelText = _useState4[0],
      setPrevOwnerLabelText = _useState4[1];

  var _useRef = useRef(id || uid()),
      inputId = _useRef.current;

  var inputNode = useRef(null);
  var classes = cx("".concat(prefix, "--btn"), className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--btn--").concat(buttonKind), buttonKind), _defineProperty(_cx, "".concat(prefix, "--btn--disabled"), disabled), _defineProperty(_cx, "".concat(prefix, "--btn--md"), size === 'field' || size === 'md'), _defineProperty(_cx, "".concat(prefix, "--btn--sm"), size === 'small' || size === 'sm'), _cx)); // Adjust label text state based on changes to the labelText prop

  if (ownerLabelText !== prevOwnerLabelText) {
    setLabelText(ownerLabelText);
    setPrevOwnerLabelText(ownerLabelText);
  }

  function onClick(event) {
    event.target.value = null;
  }

  function onKeyDown(event) {
    if (matches(event, [keys.Enter, keys.Space])) {
      inputNode.current.click();
    }
  }

  function handleOnChange(event) {
    var files = event.target.files;
    var length = event.target.files.length;

    if (files && !disableLabelChanges) {
      if (length > 1) {
        setLabelText("".concat(length, " files"));
      } else if (length === 1) {
        setLabelText(files[0].name);
      }
    }

    onChange(event);
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("label", _extends({
    tabIndex: disabled ? -1 : tabIndex || 0,
    className: classes,
    onKeyDown: onKeyDown,
    htmlFor: inputId
  }, other), /*#__PURE__*/React.createElement("span", {
    role: role,
    "aria-disabled": disabled
  }, labelText)), /*#__PURE__*/React.createElement("input", {
    className: "".concat(prefix, "--visually-hidden"),
    ref: inputNode,
    id: inputId,
    disabled: disabled,
    type: "file",
    tabIndex: "-1",
    multiple: multiple,
    accept: accept,
    name: name,
    onChange: handleOnChange,
    onClick: onClick
  }));
}

FileUploaderButton.propTypes = {
  /**
   * Specify the types of files that this input should be able to receive
   */
  accept: PropTypes.arrayOf(PropTypes.string),

  /**
   * Specify the type of underlying button
   */
  buttonKind: PropTypes.oneOf(ButtonKinds),

  /**
   * Provide a custom className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether you want to disable any updates to the FileUploaderButton
   * label
   */
  disableLabelChanges: PropTypes.bool,

  /**
   * Specify whether file input is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide a unique id for the underlying <input> node
   */
  id: PropTypes.string,

  /**
   * Provide the label text to be read by screen readers when interacting with
   * this control
   */
  labelText: PropTypes.node,

  /**
   * Specify whether you want the component to list the files that have been
   * submitted to be uploaded
   */
  listFiles: PropTypes.bool,

  /**
   * Specify if the component should accept multiple files to upload
   */
  multiple: PropTypes.bool,

  /**
   * Provide a name for the underlying <input> node
   */
  name: PropTypes.string,

  /**
   * Provide an optional `onChange` hook that is called each time the <input>
   * value changes
   */
  onChange: PropTypes.func,

  /**
   * Provide an optional `onClick` hook that is called each time the button is
   * clicked
   */
  onClick: PropTypes.func,

  /**
   * Provide an accessibility role for the <FileUploaderButton>
   */
  role: PropTypes.string,

  /**
   * Specify the size of the FileUploaderButton, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: PropTypes.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg']),

  /**
   * Provide a custom tabIndex value for the <FileUploaderButton>
   */
  tabIndex: PropTypes.number
};
export default FileUploaderButton;