var _excluded = ["labelText", "className", "disabled", "id", "placeholder", "onChange", "onClick", "hideLabel", "inline", "invalid", "invalidText", "helperText", "light", "tooltipPosition", "tooltipAlignment", "type", "hidePasswordLabel", "showPasswordLabel", "size", "onTogglePasswordVisibility", "warn", "warnText"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import React, { useContext, useEffect, useState } from 'react';
import classNames from 'classnames';
import PropTypes from 'prop-types';
import { settings } from 'carbon-components';
import { View16, ViewOff16 } from '@carbon/icons-react';
import { useNormalizedInputProps } from '../../internal/useNormalizedInputProps';
import { textInputProps } from './util';
import { FormContext } from '../FluidForm';
var prefix = settings.prefix;
var PasswordInput = /*#__PURE__*/React.forwardRef(function PasswordInput(_ref, ref) {
  var _classNames, _classNames2, _classNames3, _classNames4, _classNames7, _classNames8;

  var labelText = _ref.labelText,
      className = _ref.className,
      disabled = _ref.disabled,
      id = _ref.id,
      placeholder = _ref.placeholder,
      _onChange = _ref.onChange,
      _onClick = _ref.onClick,
      hideLabel = _ref.hideLabel,
      inline = _ref.inline,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      helperText = _ref.helperText,
      light = _ref.light,
      _ref$tooltipPosition = _ref.tooltipPosition,
      tooltipPosition = _ref$tooltipPosition === void 0 ? 'bottom' : _ref$tooltipPosition,
      _ref$tooltipAlignment = _ref.tooltipAlignment,
      tooltipAlignment = _ref$tooltipAlignment === void 0 ? 'center' : _ref$tooltipAlignment,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'password' : _ref$type,
      _ref$hidePasswordLabe = _ref.hidePasswordLabel,
      hidePasswordLabel = _ref$hidePasswordLabe === void 0 ? 'Hide password' : _ref$hidePasswordLabe,
      _ref$showPasswordLabe = _ref.showPasswordLabel,
      showPasswordLabel = _ref$showPasswordLabe === void 0 ? 'Show password' : _ref$showPasswordLabe,
      size = _ref.size,
      onTogglePasswordVisibility = _ref.onTogglePasswordVisibility,
      warn = _ref.warn,
      warnText = _ref.warnText,
      other = _objectWithoutProperties(_ref, _excluded);

  var _useState = useState(type),
      _useState2 = _slicedToArray(_useState, 2),
      inputType = _useState2[0],
      setInputType = _useState2[1];

  var normalizedProps = useNormalizedInputProps({
    id: id,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText
  });

  var handleTogglePasswordVisibility = function handleTogglePasswordVisibility(event) {
    setInputType(inputType === 'password' ? 'text' : 'password');
    onTogglePasswordVisibility && onTogglePasswordVisibility(event);
  };

  var textInputClasses = classNames("".concat(prefix, "--text-input"), "".concat(prefix, "--password-input"), className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--text-input--light"), light), _defineProperty(_classNames, "".concat(prefix, "--text-input--invalid"), normalizedProps.invalid), _defineProperty(_classNames, "".concat(prefix, "--text-input--warning"), normalizedProps.warn), _defineProperty(_classNames, "".concat(prefix, "--text-input--").concat(size), size), _classNames));

  var sharedTextInputProps = _objectSpread({
    id: id,
    onChange: function onChange(evt) {
      if (!disabled) {
        _onChange(evt);
      }
    },
    onClick: function onClick(evt) {
      if (!disabled) {
        _onClick(evt);
      }
    },
    placeholder: placeholder,
    type: inputType,
    className: textInputClasses,
    ref: ref
  }, other);

  var inputWrapperClasses = classNames("".concat(prefix, "--form-item"), "".concat(prefix, "--text-input-wrapper"), "".concat(prefix, "--password-input-wrapper"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--light"), light), _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--inline"), inline), _classNames2));
  var labelClasses = classNames("".concat(prefix, "--label"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_classNames3, "".concat(prefix, "--label--disabled"), disabled), _defineProperty(_classNames3, "".concat(prefix, "--label--inline"), inline), _defineProperty(_classNames3, "".concat(prefix, "--label--inline--").concat(size), inline && !!size), _classNames3));
  var helperTextClasses = classNames("".concat(prefix, "--form__helper-text"), (_classNames4 = {}, _defineProperty(_classNames4, "".concat(prefix, "--form__helper-text--disabled"), disabled), _defineProperty(_classNames4, "".concat(prefix, "--form__helper-text--inline"), inline), _classNames4));
  var fieldOuterWrapperClasses = classNames("".concat(prefix, "--text-input__field-outer-wrapper"), _defineProperty({}, "".concat(prefix, "--text-input__field-outer-wrapper--inline"), inline));
  var fieldWrapperClasses = classNames("".concat(prefix, "--text-input__field-wrapper"), _defineProperty({}, "".concat(prefix, "--text-input__field-wrapper--warning"), normalizedProps.warn));
  var iconClasses = classNames((_classNames7 = {}, _defineProperty(_classNames7, "".concat(prefix, "--text-input__invalid-icon"), normalizedProps.invalid || normalizedProps.warn), _defineProperty(_classNames7, "".concat(prefix, "--text-input__invalid-icon--warning"), normalizedProps.warn), _classNames7));
  var label = labelText ? /*#__PURE__*/React.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText) : null;
  var helper = helperText ? /*#__PURE__*/React.createElement("div", {
    className: helperTextClasses
  }, helperText) : null;
  var passwordIsVisible = inputType === 'text';
  var passwordVisibilityIcon = passwordIsVisible ? /*#__PURE__*/React.createElement(ViewOff16, {
    className: "".concat(prefix, "--icon-visibility-off")
  }) : /*#__PURE__*/React.createElement(View16, {
    className: "".concat(prefix, "--icon-visibility-on")
  });
  var passwordVisibilityToggleClasses = classNames("".concat(prefix, "--text-input--password__visibility__toggle"), "".concat(prefix, "--btn"), "".concat(prefix, "--btn--icon-only"), "".concat(prefix, "--tooltip__trigger"), "".concat(prefix, "--tooltip--a11y"), (_classNames8 = {}, _defineProperty(_classNames8, "".concat(prefix, "--btn--disabled"), disabled), _defineProperty(_classNames8, "".concat(prefix, "--tooltip--").concat(tooltipPosition), tooltipPosition), _defineProperty(_classNames8, "".concat(prefix, "--tooltip--align-").concat(tooltipAlignment), tooltipAlignment), _classNames8));
  var input = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("input", _extends({}, textInputProps({
    sharedTextInputProps: sharedTextInputProps,
    invalid: normalizedProps.invalid,
    invalidId: normalizedProps.invalidId,
    warn: normalizedProps.warn,
    warnId: normalizedProps.warnId
  }), {
    disabled: disabled,
    "data-toggle-password-visibility": inputType === 'password'
  })), /*#__PURE__*/React.createElement("button", {
    type: "button",
    className: passwordVisibilityToggleClasses,
    disabled: disabled,
    onClick: handleTogglePasswordVisibility
  }, !disabled && /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--assistive-text")
  }, passwordIsVisible ? hidePasswordLabel : showPasswordLabel), passwordVisibilityIcon));

  var _useContext = useContext(FormContext),
      isFluid = _useContext.isFluid;

  useEffect(function () {
    setInputType(type);
  }, [type]);
  return /*#__PURE__*/React.createElement("div", {
    className: inputWrapperClasses
  }, !inline ? label : /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--text-input__label-helper-wrapper")
  }, label, !isFluid && helper), /*#__PURE__*/React.createElement("div", {
    className: fieldOuterWrapperClasses
  }, /*#__PURE__*/React.createElement("div", {
    className: fieldWrapperClasses,
    "data-invalid": normalizedProps.invalid || null
  }, normalizedProps.icon && /*#__PURE__*/React.createElement(normalizedProps.icon, {
    className: iconClasses
  }), input, isFluid && !inline && normalizedProps.validation), !isFluid && !inline && (normalizedProps.validation || helper)));
});
PasswordInput.displayName = 'PasswordInput';
PasswordInput.propTypes = {
  /**
   * Provide a custom className that is applied directly to the underlying
   * `<input>` node
   */
  className: PropTypes.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify whether the control is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: PropTypes.node,

  /**
   * Specify whether or not the underlying label is visually hidden
   */
  hideLabel: PropTypes.bool,

  /**
   * "Hide password" tooltip text on password visibility toggle
   */
  hidePasswordLabel: PropTypes.string,

  /**
   * Provide a unique identifier for the input field
   */
  id: PropTypes.string.isRequired,

  /**
   * `true` to use the inline version.
   */
  inline: PropTypes.bool,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: PropTypes.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: PropTypes.node.isRequired,

  /**
   * Specify light version or default version of this control
   */
  light: PropTypes.bool,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<input>`
   * is updated
   */
  onChange: PropTypes.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<input>` is clicked
   */
  onClick: PropTypes.func,

  /**
   * Callback function that is called whenever the toggle password visibility
   * button is clicked
   */
  onTogglePasswordVisibility: PropTypes.func,

  /**
   * Specify the placeholder attribute for the `<input>`
   */
  placeholder: PropTypes.string,

  /**
   * "Show password" tooltip text on password visibility toggle
   */
  showPasswordLabel: PropTypes.string,

  /**
   * Specify the size of the Text Input. Currently supports either `small` or `large` as an option. If omitted, defaults to standard size
   */
  size: PropTypes.string,

  /**
   * Specify the alignment of the tooltip to the icon-only button.
   * Can be one of: start, center, or end.
   */
  tooltipAlignment: PropTypes.oneOf(['start', 'center', 'end']),

  /**
   * Specify the direction of the tooltip for icon-only buttons.
   * Can be either top, right, bottom, or left.
   */
  tooltipPosition: PropTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * The input type, either password or text
   */
  type: PropTypes.oneOf(['password', 'text']),

  /**
   * Provide the current value of the `<input>`
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: PropTypes.node
};
PasswordInput.defaultProps = {
  className: '${prefix}--text__input',
  disabled: false,
  onChange: function onChange() {},
  onClick: function onClick() {},
  invalid: false,
  invalidText: '',
  helperText: '',
  light: false,
  size: ''
};
export default PasswordInput;