/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { mount } from 'enzyme';
import { Document16, Folder16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import TreeView, { TreeNode } from './';
var prefix = settings.prefix;
describe('TreeView', function () {
  var wrapper;
  var onTreeSelect;
  var onNodeSelect;
  beforeEach(function () {
    onTreeSelect = jest.fn();
    onNodeSelect = jest.fn();
    wrapper = mount( /*#__PURE__*/React.createElement(TreeView, {
      label: "Tree view",
      selected: ['1'],
      onSelect: onTreeSelect
    }, /*#__PURE__*/React.createElement(TreeNode, {
      id: "1",
      value: "1",
      label: "1"
    }), /*#__PURE__*/React.createElement(TreeNode, {
      id: "2",
      value: "2",
      label: "2",
      onSelect: onNodeSelect
    }), /*#__PURE__*/React.createElement(TreeNode, {
      id: "5",
      value: "5",
      label: "5",
      isExpanded: true
    }, /*#__PURE__*/React.createElement(TreeNode, {
      id: "5-1",
      value: "5-1",
      label: "5-1"
    }), /*#__PURE__*/React.createElement(TreeNode, {
      id: "5-2",
      value: "5-2",
      label: "5-2"
    }), /*#__PURE__*/React.createElement(TreeNode, {
      id: "5-3",
      value: "5-3",
      label: "5-3",
      isExpanded: true
    }, /*#__PURE__*/React.createElement(TreeNode, {
      id: "5-4",
      value: "5-4",
      label: "5-4"
    })))));
  });
  it('should render', function () {
    expect(wrapper).toMatchSnapshot();
  });
  it('should render with icons', function () {
    wrapper = mount( /*#__PURE__*/React.createElement(TreeView, {
      label: "Tree view",
      selected: ['1']
    }, /*#__PURE__*/React.createElement(TreeNode, {
      renderIcon: Document16,
      id: "1",
      value: "1",
      label: "1"
    }), /*#__PURE__*/React.createElement(TreeNode, {
      renderIcon: Document16,
      id: "2",
      value: "2",
      label: "2"
    }), /*#__PURE__*/React.createElement(TreeNode, {
      renderIcon: Folder16,
      id: "5",
      value: "5",
      label: "5",
      isExpanded: true
    }, /*#__PURE__*/React.createElement(TreeNode, {
      renderIcon: Document16,
      id: "5-1",
      value: "5-1",
      label: "5-1"
    }), /*#__PURE__*/React.createElement(TreeNode, {
      renderIcon: Document16,
      id: "5-2",
      value: "5-2",
      label: "5-2"
    }), /*#__PURE__*/React.createElement(TreeNode, {
      renderIcon: Folder16,
      id: "5-3",
      value: "5-3",
      label: "5-3",
      isExpanded: true
    }, /*#__PURE__*/React.createElement(TreeNode, {
      renderIcon: Document16,
      id: "5-4",
      value: "5-4",
      label: "5-4"
    })))));
    expect(wrapper).toMatchSnapshot();
  });
  it('should be able to hide the label', function () {
    expect(wrapper.find('TreeLabel').text()).toBe('Tree view');
    wrapper.setProps({
      hideLabel: true
    });
    expect(wrapper.find('TreeLabel').text()).toBeFalsy();
  });
  describe('Single node selection', function () {
    it('should be able to preselect a node', function () {
      expect(wrapper.find(".".concat(prefix, "--tree-node--selected")).text()).toBe('1');
    });
    it('should handle selection at the tree level', function () {
      var onTreeSelect = jest.fn();
      wrapper.setProps({
        onSelect: onTreeSelect
      });
      wrapper.find('TreeNode[value="2"]').simulate('click');
      expect(onTreeSelect).toHaveBeenCalledTimes(1);
    });
    it('should handle selection at the node level', function () {
      wrapper.find('TreeNode[value="2"]').simulate('click');
      expect(onTreeSelect).toHaveBeenCalledTimes(1);
      expect(onNodeSelect).toHaveBeenCalledTimes(1);
    });
  });
  describe('Tree node expansion', function () {
    it('Caret icon should not render in leaf nodes', function () {
      expect(wrapper.find('ForwardRef(CaretDown16)').length).toBe(2);
    });
  });
});