/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { useEffect, useRef } from 'react';
export function useEvent(element, eventName, callback) {
  var savedCallback = useRef(null);
  useEffect(function () {
    savedCallback.current = callback;
  });
  useEffect(function () {
    function handler(event) {
      if (savedCallback.current) {
        savedCallback.current(event);
      }
    }

    element.addEventListener(eventName, handler);
    return function () {
      element.removeEventListener(eventName, handler);
    };
  }, [element, eventName]);
}