"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.skeletonPlayground = exports.playground = exports.skeleton = exports.accordion = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Accordion = _interopRequireWildcard(require("../Accordion"));

var _Button = _interopRequireDefault(require("../Button"));

var _Accordion2 = _interopRequireDefault(require("./Accordion.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var _default = {
  title: 'Components/Accordion',
  component: _Accordion.default,
  subcomponents: {
    AccordionItem: _Accordion.AccordionItem,
    AccordionSkeleton: _Accordion.AccordionSkeleton
  },
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Accordion2.default
    }
  }
};
exports.default = _default;

var accordion = function accordion() {
  return /*#__PURE__*/_react.default.createElement(_Accordion.default, null, /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, {
    title: "Section 1 title"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, {
    title: "Section 2 title"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, {
    title: "Section 3 title"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, {
    title: "Section 4 title"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")));
};

exports.accordion = accordion;

var skeleton = function skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Accordion.AccordionSkeleton, {
    open: true,
    count: 4
  });
};

exports.skeleton = skeleton;
skeleton.decorators = [function (story) {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '500px'
    }
  }, story());
}];
var props = {
  onClick: (0, _addonActions.action)('onClick'),
  onHeadingClick: (0, _addonActions.action)('onHeadingClick')
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};

var playground = function playground() {
  return /*#__PURE__*/_react.default.createElement(_Accordion.default, {
    disabled: (0, _addonKnobs.boolean)('Disable entire Accordion (disabled)', false),
    size: (0, _addonKnobs.select)('Accordion heading size (size)', sizes, undefined) || undefined,
    align: (0, _addonKnobs.select)('Accordion heading alignment (align)', ['start', 'end'], 'end')
  }, /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, _extends({
    title: (0, _addonKnobs.text)('The title (title)', 'Section 1 title'),
    open: (0, _addonKnobs.boolean)('Open the section (open)', false)
  }, props), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, _extends({
    title: "Section 2 title"
  }, props), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")), /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, _extends({
    title: "Section 3 title"
  }, props, {
    disabled: (0, _addonKnobs.boolean)('Disable Section 3 (disabled)', true)
  }), /*#__PURE__*/_react.default.createElement(_Button.default, null, "This is a button.")), /*#__PURE__*/_react.default.createElement(_Accordion.AccordionItem, _extends({
    title: /*#__PURE__*/_react.default.createElement("span", null, "Section 4 title (", /*#__PURE__*/_react.default.createElement("em", null, "the title can be a node"), ")")
  }, props), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.")));
};

exports.playground = playground;

var skeletonPlayground = function skeletonPlayground() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '500px'
    }
  }, /*#__PURE__*/_react.default.createElement(_Accordion.AccordionSkeleton, {
    align: (0, _addonKnobs.select)('Accordion heading alignment (align)', ['start', 'end'], 'end'),
    open: (0, _addonKnobs.boolean)('Show first item opened (open)', true),
    count: (0, _addonKnobs.number)('Set number of items (count)', 4)
  }));
};

exports.skeletonPlayground = skeletonPlayground;