"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FocusScope = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _useMergedRefs = require("../../internal/useMergedRefs");

var _useAutoFocus = require("./useAutoFocus");

var _useFocusScope = require("./useFocusScope");

var _useRestoreFocus = require("./useRestoreFocus");

var _excluded = ["as", "children", "initialFocusRef"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var FocusScope = /*#__PURE__*/React.forwardRef(function FocusScope(props, forwardRef) {
  var _props$as = props.as,
      BaseComponent = _props$as === void 0 ? 'div' : _props$as,
      children = props.children,
      initialFocusRef = props.initialFocusRef,
      rest = _objectWithoutProperties(props, _excluded);

  var containerRef = React.useRef(null);
  var focusScope = (0, _useFocusScope.useFocusScope)(containerRef);
  var ref = (0, _useMergedRefs.useMergedRefs)([forwardRef, containerRef]);
  (0, _useRestoreFocus.useRestoreFocus)(containerRef);
  (0, _useAutoFocus.useAutoFocus)(function () {
    if (initialFocusRef) {
      return initialFocusRef;
    }

    return focusScope.current.getFirstDescendant();
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FocusScopeBumper, {
    onFocus: function onFocus() {
      focusScope.current.focusLastDescendant();
    }
  }), /*#__PURE__*/React.createElement(BaseComponent, _extends({}, rest, {
    ref: ref
  }), children), /*#__PURE__*/React.createElement(FocusScopeBumper, {
    onFocus: function onFocus() {
      focusScope.current.focusFirstDescendant();
    }
  }));
});
exports.FocusScope = FocusScope;

if (process.env.NODE_ENV !== "production") {
  FocusScope.displayName = 'FocusScope';
}

FocusScope.propTypes = {
  /**
   * Provide a custom element type for the containing element
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide the children to be rendered inside of the `FocusScope`
   */
  children: _propTypes.default.node,

  /**
   * Provide a `ref` that is used to place focus when the `FocusScope` is
   * initially opened
   */
  initialFocusRef: _propTypes.default.shape({
    current: _propTypes.default.any
  })
};
var bumperStyle = {
  outline: 'none',
  opacity: '0',
  position: 'fixed',
  pointerEvents: 'none'
};

function FocusScopeBumper(props) {
  return /*#__PURE__*/React.createElement("span", _extends({
    "data-carbon-focus-scope": "",
    style: bumperStyle // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: "0"
  }, props));
}