"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.translationIds = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _excluded = ["isOpen", "translateWithId"];

var _defaultTranslations;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;
var translationIds = {
  'close.menu': 'close.menu',
  'open.menu': 'open.menu'
};
exports.translationIds = translationIds;
var defaultTranslations = (_defaultTranslations = {}, _defineProperty(_defaultTranslations, translationIds['close.menu'], 'Close'), _defineProperty(_defaultTranslations, translationIds['open.menu'], 'Open'), _defaultTranslations);
/**
 * `ListBoxTrigger` is used to orient the icon up or down depending on the
 * state of the menu for a given `ListBox`
 */

var ListBoxTrigger = function ListBoxTrigger(_ref) {
  var _cx;

  var isOpen = _ref.isOpen,
      t = _ref.translateWithId,
      rest = _objectWithoutProperties(_ref, _excluded);

  var className = (0, _classnames.default)((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--list-box__menu-icon"), true), _defineProperty(_cx, "".concat(prefix, "--list-box__menu-icon--open"), isOpen), _cx));
  var description = isOpen ? t('close.menu') : t('open.menu');
  return /*#__PURE__*/_react.default.createElement("button", _extends({}, rest, {
    "aria-label": description,
    title: description,
    className: className,
    type: "button",
    tabIndex: "-1"
  }), /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown16, null));
};

ListBoxTrigger.propTypes = {
  /**
   * Specify whether the menu is currently open, which will influence the
   * direction of the menu icon
   */
  isOpen: _propTypes.default.bool.isRequired,

  /**
   * i18n hook used to provide the appropriate description for the given menu
   * icon. This function takes in an id defined in `translationIds` and should
   * return a string message for that given message id.
   */
  translateWithId: _propTypes.default.func.isRequired
};
ListBoxTrigger.defaultProps = {
  translateWithId: function translateWithId(id) {
    return defaultTranslations[id];
  }
};
var _default = ListBoxTrigger;
exports.default = _default;