"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _carbonComponents = require("carbon-components");

var _keyboard = require("../../internal/keyboard");

var _utils = require("./_utils");

var _MenuGroup = _interopRequireDefault(require("./MenuGroup"));

var _MenuRadioGroup = _interopRequireDefault(require("./MenuRadioGroup"));

var _MenuRadioGroupOptions = _interopRequireDefault(require("./MenuRadioGroupOptions"));

var _MenuSelectableItem = _interopRequireDefault(require("./MenuSelectableItem"));

var _excluded = ["children", "id", "level", "open", "size", "x", "y", "onClose"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
var margin = 16; // distance to keep to body edges, in px

var defaultSize = 'sm';

var Menu = function Menu(_ref) {
  var _classnames;

  var children = _ref.children,
      id = _ref.id,
      _ref$level = _ref.level,
      level = _ref$level === void 0 ? 1 : _ref$level,
      open = _ref.open,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? defaultSize : _ref$size,
      _ref$x = _ref.x,
      x = _ref$x === void 0 ? 0 : _ref$x,
      _ref$y = _ref.y,
      y = _ref$y === void 0 ? 0 : _ref$y,
      _ref$onClose = _ref.onClose,
      onClose = _ref$onClose === void 0 ? function () {} : _ref$onClose,
      rest = _objectWithoutProperties(_ref, _excluded);

  var rootRef = (0, _react.useRef)(null);

  var _useState = (0, _react.useState)(1),
      _useState2 = _slicedToArray(_useState, 2),
      direction = _useState2[0],
      setDirection = _useState2[1]; // 1 = to right, -1 = to left


  var _useState3 = (0, _react.useState)([x, y]),
      _useState4 = _slicedToArray(_useState3, 2),
      position = _useState4[0],
      setPosition = _useState4[1];

  var isRootMenu = level === 1;
  var focusReturn = (0, _react.useRef)(null);

  function returnFocus() {
    if (focusReturn.current) {
      focusReturn.current.focus();
    }
  }

  function close(eventType) {
    var isKeyboardEvent = /^key/.test(eventType);

    if (isKeyboardEvent) {
      window.addEventListener('keyup', returnFocus, {
        once: true
      });
    } else {
      window.addEventListener('mouseup', returnFocus, {
        once: true
      });
    }

    onClose();
  }

  function getContainerBoundaries() {
    var _document$body = document.body,
        bodyWidth = _document$body.clientWidth,
        bodyHeight = _document$body.clientHeight;
    return [margin, margin, bodyWidth - margin, bodyHeight - margin];
  }

  function getTargetBoundaries() {
    var xIsRange = _typeof(x) === 'object' && x.length === 2;
    var yIsRange = _typeof(y) === 'object' && y.length === 2;
    var targetBoundaries = [xIsRange ? x[0] : x, yIsRange ? y[0] : y, xIsRange ? x[1] : x, yIsRange ? y[1] : y];

    if (!isRootMenu) {
      var _getParentMenu;

      var _getParentMenu$getBou = (_getParentMenu = (0, _utils.getParentMenu)(rootRef.current)) === null || _getParentMenu === void 0 ? void 0 : _getParentMenu.getBoundingClientRect(),
          parentWidth = _getParentMenu$getBou.width;

      targetBoundaries[2] -= parentWidth;
    }

    var containerBoundaries = getContainerBoundaries();
    return [(0, _utils.capWithinRange)(targetBoundaries[0], containerBoundaries[0], containerBoundaries[2]), (0, _utils.capWithinRange)(targetBoundaries[1], containerBoundaries[1], containerBoundaries[3]), (0, _utils.capWithinRange)(targetBoundaries[2], containerBoundaries[0], containerBoundaries[2]), (0, _utils.capWithinRange)(targetBoundaries[3], containerBoundaries[1], containerBoundaries[3])];
  }

  function focusNode(node) {
    if (node) {
      (0, _utils.resetFocus)(rootRef.current);
      (0, _utils.focusNode)(node);
    }
  }

  function handleKeyDown(event) {
    if ((0, _keyboard.match)(event, _keyboard.keys.Tab)) {
      event.preventDefault();
      close(event.type);
    }

    if (event.target.tagName === 'LI' && ((0, _keyboard.match)(event, _keyboard.keys.Enter) || (0, _keyboard.match)(event, _keyboard.keys.Space))) {
      handleClick(event);
    } else {
      event.stopPropagation();
    }

    if ((0, _keyboard.match)(event, _keyboard.keys.Escape) || !isRootMenu && (0, _keyboard.match)(event, _keyboard.keys.ArrowLeft)) {
      close(event.type);
    }

    var nodeToFocus;

    if (event.target.tagName === 'LI') {
      var currentNode = event.target;

      if ((0, _keyboard.match)(event, _keyboard.keys.ArrowUp)) {
        nodeToFocus = (0, _utils.getNextNode)(currentNode, -1);
      } else if ((0, _keyboard.match)(event, _keyboard.keys.ArrowDown)) {
        nodeToFocus = (0, _utils.getNextNode)(currentNode, 1);
      } else if ((0, _keyboard.match)(event, _keyboard.keys.ArrowLeft)) {
        nodeToFocus = (0, _utils.getParentNode)(currentNode);
      }
    } else if (event.target.tagName === 'UL') {
      var validNodes = (0, _utils.getValidNodes)(event.target);

      if (validNodes.length > 0 && (0, _keyboard.match)(event, _keyboard.keys.ArrowUp)) {
        nodeToFocus = validNodes[validNodes.length - 1];
      } else if (validNodes.length > 0 && (0, _keyboard.match)(event, _keyboard.keys.ArrowDown)) {
        nodeToFocus = validNodes[0];
      }
    }

    focusNode(nodeToFocus);

    if (rest.onKeyDown) {
      rest.onKeyDown(event);
    }
  }

  function handleClick(event) {
    if (!(0, _utils.clickedElementHasSubnodes)(event) && event.target.tagName !== 'UL') {
      close(event.type);
    } else {
      event.stopPropagation();
    }
  }

  function getCorrectedPosition(preferredDirection) {
    var _rootRef$current;

    var elementRect = (_rootRef$current = rootRef.current) === null || _rootRef$current === void 0 ? void 0 : _rootRef$current.getBoundingClientRect();
    var elementDimensions = [elementRect.width, elementRect.height];
    var targetBoundaries = getTargetBoundaries();
    var containerBoundaries = getContainerBoundaries();

    var _getPosition = (0, _utils.getPosition)(elementDimensions, targetBoundaries, containerBoundaries, preferredDirection),
        correctedPosition = _getPosition.position,
        correctedDirection = _getPosition.direction;

    setDirection(correctedDirection);
    return correctedPosition;
  }

  function handleBlur(event) {
    var _rootRef$current2;

    if (isRootMenu && !((_rootRef$current2 = rootRef.current) !== null && _rootRef$current2 !== void 0 && _rootRef$current2.contains(event.relatedTarget))) {
      close(event.type);
    }
  }

  (0, _react.useEffect)(function () {
    if (open) {
      focusReturn.current = document.activeElement;
      var localDirection = 1;

      if (isRootMenu) {
        var _rootRef$current3;

        (_rootRef$current3 = rootRef.current) === null || _rootRef$current3 === void 0 ? void 0 : _rootRef$current3.focus();
      } else {
        var parentMenu = (0, _utils.getParentMenu)(rootRef.current);

        if (parentMenu) {
          localDirection = Number(parentMenu.dataset.direction);
        }
      }

      var correctedPosition = getCorrectedPosition(localDirection);
      setPosition(correctedPosition);
    } else {
      setPosition([0, 0]);
    } // eslint-disable-next-line react-hooks/exhaustive-deps

  }, [open, x, y]);

  var someNodesHaveIcons = _react.default.Children.toArray(children).some(function (node) {
    return node.type === _MenuSelectableItem.default || node.type === _MenuRadioGroup.default;
  });

  var options = _react.default.Children.map(children, function (node) {
    if ( /*#__PURE__*/_react.default.isValidElement(node)) {
      return /*#__PURE__*/_react.default.cloneElement(node, {
        indented: someNodesHaveIcons,
        level: level
      });
    }
  });

  var classes = (0, _classnames2.default)("".concat(prefix, "--menu"), (_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--menu--open"), open), _defineProperty(_classnames, "".concat(prefix, "--menu--invisible"), open && position[0] === 0 && position[1] === 0), _defineProperty(_classnames, "".concat(prefix, "--menu--root"), isRootMenu), _classnames), size !== defaultSize && "".concat(prefix, "--menu--").concat(size));
  var ulAttributes = {
    id: id,
    ref: rootRef,
    className: classes,
    onKeyDown: handleKeyDown,
    onClick: handleClick,
    onBlur: handleBlur,
    role: 'menu',
    tabIndex: -1,
    'data-direction': direction,
    'data-level': level,
    style: {
      left: "".concat(position[0], "px"),
      top: "".concat(position[1], "px")
    }
  };
  var childrenToRender = options; // if the only child is a radiogroup, don't render it as radiogroup component, but
  // only the items to prevent duplicate markup

  if (options && options.length === 1 && options[0].type === _MenuRadioGroup.default) {
    var radioGroupProps = options[0].props;
    ulAttributes['aria-label'] = radioGroupProps.label;
    childrenToRender = /*#__PURE__*/_react.default.createElement(_MenuRadioGroupOptions.default, {
      items: radioGroupProps.items,
      initialSelectedItem: radioGroupProps.initialSelectedItem,
      onChange: radioGroupProps.onChange
    });
  } // if the only child is a generic group, don't render it as group component, but
  // only the children to prevent duplicate markup


  if (options && options.length === 1 && options[0].type === _MenuGroup.default) {
    var groupProps = options[0].props;
    ulAttributes['aria-label'] = groupProps.label;
    childrenToRender = _react.default.Children.toArray(options[0].props.children);
  }

  var menu = /*#__PURE__*/_react.default.createElement("ul", ulAttributes, childrenToRender);

  return isRootMenu ? open && /*#__PURE__*/_reactDom.default.createPortal(menu, document.body) || null : menu;
};

Menu.propTypes = {
  /**
   * Specify the children of the Menu
   */
  children: _propTypes.default.node,

  /**
   * Define an ID for this menu
   */
  id: _propTypes.default.string,

  /**
   * Internal: keeps track of the nesting level of the menu
   */
  level: _propTypes.default.number,

  /**
   * Function called when the menu is closed
   */
  onClose: _propTypes.default.func,

  /**
   * Specify whether the Menu is currently open
   */
  open: _propTypes.default.bool,

  /**
   * Specify the size of the menu, from a list of available sizes.
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg']),

  /**
   * Specify the x position where this menu is rendered
   */
  x: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.arrayOf(_propTypes.default.number)]),

  /**
   * Specify the y position where this menu is rendered
   */
  y: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.arrayOf(_propTypes.default.number)])
};
var _default = Menu;
exports.default = _default;