"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Examples = exports.Playground = exports.Default = exports.default = void 0;

require("./story.scss");

var _iconsReact = require("@carbon/icons-react");

var _addonKnobs = require("@storybook/addon-knobs");

var _react = _interopRequireDefault(require("react"));

var _Popover = require("../Popover");

var _Button = _interopRequireDefault(require("../Button"));

var _Popover2 = _interopRequireDefault(require("./Popover.mdx"));

var _useOutsideClick = require("../../internal/useOutsideClick");

var _excluded = ["children", "align", "relative", "icon", "size", "flip"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var _default = {
  title: 'Experimental/unstable_Popover',
  component: _Popover.Popover,
  subcomponents: {
    PopoverContent: _Popover.PopoverContent
  },
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Popover2.default
    }
  },
  includeStories: ['Playground']
};
exports.default = _default;

var Default = function Default() {
  function PopoverDemo() {
    var _React$useState = _react.default.useState('top'),
        _React$useState2 = _slicedToArray(_React$useState, 2),
        align = _React$useState2[0],
        setAlign = _React$useState2[1];

    var _React$useState3 = _react.default.useState(true),
        _React$useState4 = _slicedToArray(_React$useState3, 2),
        open = _React$useState4[0],
        setOpen = _React$useState4[1];

    var choices = ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement("h2", null, "Caret Position"), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'grid',
        gridTemplateColumns: 'repeat(3, auto)',
        gridGap: 8
      }
    }, choices.map(function (choice) {
      return /*#__PURE__*/_react.default.createElement("label", {
        key: choice
      }, /*#__PURE__*/_react.default.createElement("input", {
        type: "radio",
        name: "align",
        value: choice,
        checked: choice === align,
        onChange: function onChange() {
          setAlign(choice);
        }
      }), choice);
    }))), /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement("h2", null, "Popover Visibility"), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("label", null, /*#__PURE__*/_react.default.createElement("input", {
      type: "checkbox",
      value: open,
      checked: open,
      onChange: function onChange() {
        setOpen(!open);
      }
    }), "Open"))), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        marginTop: '2rem'
      }
    }, /*#__PURE__*/_react.default.createElement(_Popover.Popover, {
      open: open,
      align: align,
      relative: true
    }, /*#__PURE__*/_react.default.createElement(_Popover.PopoverContent, {
      className: "p-3"
    }, "Hello"))));
  }

  return /*#__PURE__*/_react.default.createElement(PopoverDemo, null);
};

exports.Default = Default;

var Playground = function Playground() {
  var options = ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'];
  return /*#__PURE__*/_react.default.createElement(_Popover.Popover, {
    align: (0, _addonKnobs.select)('Specify the caret alignment (align)', options, 'top'),
    caret: (0, _addonKnobs.boolean)('Specify whether the caret should be visible (caret)', true),
    highContrast: (0, _addonKnobs.boolean)('Specify whether the high-contrast variant should render (highContrast)', false),
    light: (0, _addonKnobs.boolean)('Specify whether the light variant should render (light)', false),
    open: (0, _addonKnobs.boolean)('Specify whether the popover is open or closed (open)', true)
  }, /*#__PURE__*/_react.default.createElement(_Popover.PopoverContent, {
    className: "p-3"
  }, "Sample content"));
};

exports.Playground = Playground;
Playground.story = {
  decorators: [function (story) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mt-9"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "position-relative"
    }, story()));
  }]
};

var Examples = function Examples() {
  function Example(_ref) {
    var children = _ref.children,
        align = _ref.align,
        _ref$relative = _ref.relative,
        relative = _ref$relative === void 0 ? false : _ref$relative,
        icon = _ref.icon,
        size = _ref.size,
        _ref$flip = _ref.flip,
        flip = _ref$flip === void 0 ? false : _ref$flip,
        rest = _objectWithoutProperties(_ref, _excluded);

    var ref = _react.default.useRef(null);

    var _React$useState5 = _react.default.useState(false),
        _React$useState6 = _slicedToArray(_React$useState5, 2),
        open = _React$useState6[0],
        setOpen = _React$useState6[1];

    (0, _useOutsideClick.useOutsideClick)(ref, function () {
      if (open === true) {
        setOpen(false);
      }
    });

    if (flip) {
      return /*#__PURE__*/_react.default.createElement("div", _extends({
        ref: ref
      }, rest), /*#__PURE__*/_react.default.createElement(_Popover.Popover, {
        align: align,
        open: open,
        relative: relative
      }, /*#__PURE__*/_react.default.createElement(_Popover.PopoverContent, {
        className: "p-3"
      }, children)), /*#__PURE__*/_react.default.createElement(_Button.default, {
        iconDescription: "Toggle",
        hasIconOnly: true,
        onClick: function onClick() {
          setOpen(!open);
        },
        renderIcon: icon,
        size: size
      }));
    }

    return /*#__PURE__*/_react.default.createElement("div", _extends({
      ref: ref
    }, rest), /*#__PURE__*/_react.default.createElement(_Button.default, {
      iconDescription: "Toggle",
      hasIconOnly: true,
      onClick: function onClick() {
        setOpen(!open);
      },
      renderIcon: icon,
      size: size
    }), /*#__PURE__*/_react.default.createElement(_Popover.Popover, {
      align: align,
      open: open,
      relative: relative
    }, /*#__PURE__*/_react.default.createElement(_Popover.PopoverContent, {
      className: "p-3"
    }, children)));
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative mb-3",
    icon: _iconsReact.CaretDown32,
    align: "bottom-left"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative mb-3",
    icon: _iconsReact.CaretDown32,
    align: "bottom-left",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: _iconsReact.CaretDown32,
    align: "top"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: _iconsReact.CaretDown32,
    align: "top",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: _iconsReact.CaretDown32,
    align: "bottom-right"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: _iconsReact.CaretDown32,
    align: "bottom-right",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative mb-3",
    icon: _iconsReact.CaretUp32,
    align: "top-left"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative mb-3",
    icon: _iconsReact.CaretUp32,
    align: "top-left",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: _iconsReact.CaretUp32,
    align: "top"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: _iconsReact.CaretUp32,
    align: "top",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: _iconsReact.CaretUp32,
    align: "top-right"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: _iconsReact.CaretUp32,
    align: "top-right",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/_react.default.createElement("div", {
    className: "grid grid-cols-3 mb-3"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretRight32,
    align: "right",
    relative: true
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretRight32,
    align: "right",
    size: "sm",
    relative: true
  }, "This is some text")), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretRight32,
    align: "right-top",
    relative: true
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretRight32,
    align: "right-top",
    size: "sm",
    relative: true
  }, "This is some text")), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretRight32,
    align: "right-bottom",
    relative: true
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretRight32,
    align: "right-bottom",
    size: "sm",
    relative: true
  }, "This is some text"))), /*#__PURE__*/_react.default.createElement("div", {
    className: "grid grid-cols-3 justify-items-end mb-3"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretLeft32,
    align: "left",
    relative: true,
    flip: true
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretLeft32,
    align: "left",
    size: "sm",
    relative: true,
    flip: true
  }, "This is some text")), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretLeft32,
    align: "left-top",
    relative: true,
    flip: true
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretLeft32,
    align: "left-top",
    size: "sm",
    relative: true,
    flip: true
  }, "This is some text")), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretLeft32,
    align: "left-bottom",
    relative: true,
    flip: true
  }, "This is some text"), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: _iconsReact.CaretLeft32,
    align: "left-bottom",
    size: "sm",
    relative: true,
    flip: true
  }, "This is some text"))), /*#__PURE__*/_react.default.createElement(Example, {
    className: "position-relative mb-3",
    icon: _iconsReact.CaretDown32,
    align: "bottom-left"
  }, "Consectetur et sit accusamus laboriosam pariatur. Asperiores eius expedita eligendi beatae vero commodi harum Illo hic accusamus fugit commodi cupiditate Explicabo distinctio quisquam culpa fugit eius Provident voluptatum ipsam quo."));
};

exports.Examples = Examples;