"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _useId = require("../../internal/useId");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;

function ProgressBar(_ref) {
  var className = _ref.className,
      hideLabel = _ref.hideLabel,
      label = _ref.label,
      _ref$max = _ref.max,
      max = _ref$max === void 0 ? 100 : _ref$max,
      value = _ref.value,
      helperText = _ref.helperText;
  var labelId = (0, _useId.useId)('progress-bar');
  var helperId = (0, _useId.useId)('progress-bar-helper');
  var indeterminate = value === null || value === undefined;
  var cappedValue = value;

  if (cappedValue > max) {
    cappedValue = max;
  }

  if (cappedValue < 0) {
    cappedValue = 0;
  }

  var percentage = cappedValue / max;
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--progress-bar"), _defineProperty({}, "".concat(prefix, "--progress-bar--indeterminate"), indeterminate), className);
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--progress-bar__label"), _defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: labelClasses,
    id: labelId
  }, label), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--progress-bar__track"),
    role: "progressbar",
    "aria-labelledby": labelId,
    "aria-describedby": helperText ? helperId : null,
    "aria-valuemin": !indeterminate ? 0 : null,
    "aria-valuemax": !indeterminate ? max : null,
    "aria-valuenow": !indeterminate ? cappedValue : null
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--progress-bar__bar"),
    style: {
      transform: "scaleX(".concat(percentage, ")")
    }
  })), helperText && /*#__PURE__*/_react.default.createElement("div", {
    id: helperId,
    className: "".concat(prefix, "--progress-bar__helper-text")
  }, helperText));
}

ProgressBar.propTypes = {
  /**
   * Additional CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * The current progress as a textual representation.
   */
  helperText: _propTypes.default.string,

  /**
   * Whether the label should be visually hidden.
   */
  hideLabel: _propTypes.default.bool,

  /**
   * A label describing the progress bar.
   */
  label: _propTypes.default.string.isRequired,

  /**
   * The maximum value.
   */
  max: _propTypes.default.number,

  /**
   * The current value.
   */
  value: _propTypes.default.number
};
var _default = ProgressBar;
exports.default = _default;