"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _RadioButtonGroup = _interopRequireDefault(require("../RadioButtonGroup"));

var _RadioButton = _interopRequireDefault(require("../RadioButton"));

var _RadioButton2 = _interopRequireDefault(require("./RadioButton.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var values = {
  'Option 1': 'radio-1',
  'Option 2': 'radio-2',
  'Option 3': 'radio-3'
};
var orientations = {
  'Horizontal (horizontal)': 'horizontal',
  'Vertical (vertical)': 'vertical'
};
var labelPositions = {
  'Left (left)': 'left',
  'Right (right)': 'right'
};
var props = {
  group: function group() {
    return {
      legendText: (0, _addonKnobs.text)('The label (legend) of the RadioButtonGroup (legendText)', 'Radio button heading'),
      name: (0, _addonKnobs.text)('The form control name (name in <RadioButtonGroup>)', 'radio-button-group'),
      valueSelected: (0, _addonKnobs.select)('Value of the selected button (valueSelected in <RadioButtonGroup>)', values, 'radio-3'),
      orientation: (0, _addonKnobs.select)('Radio button orientation (orientation)', orientations, 'horizontal'),
      labelPosition: (0, _addonKnobs.select)('Label position (labelPosition)', labelPositions, 'right'),
      onChange: (0, _addonActions.action)('onChange')
    };
  },
  radio: function radio() {
    return {
      className: 'some-class',
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <RadioButton>)', false),
      labelText: (0, _addonKnobs.text)('The label of the RadioButton (labelText)', 'Option 1')
    };
  }
};
var _default = {
  title: 'Components/RadioButton',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _RadioButtonGroup.default,
    docs: {
      page: _RadioButton2.default
    },
    subcomponents: {
      RadioButton: _RadioButton.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_RadioButtonGroup.default, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  }));
};

exports.Default = Default;

var Playground = function Playground() {
  var radioProps = props.radio();
  return /*#__PURE__*/_react.default.createElement(_RadioButtonGroup.default, _extends({
    labelText: "Radio Button group"
  }, props.group()), /*#__PURE__*/_react.default.createElement(_RadioButton.default, _extends({
    value: "radio-1",
    id: "radio-1"
  }, radioProps)), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/_react.default.createElement(_RadioButton.default, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  }));
};

exports.Playground = Playground;