"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _warning = require("../../internal/warning");

var _carbonComponents = require("carbon-components");

var _Text = require("../Text");

var _FeatureFlags = require("../FeatureFlags");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;

var RadioButtonGroup = /*#__PURE__*/function (_React$Component) {
  _inherits(RadioButtonGroup, _React$Component);

  var _super = _createSuper(RadioButtonGroup);

  function RadioButtonGroup() {
    var _this;

    _classCallCheck(this, RadioButtonGroup);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      selected: typeof _this.props.valueSelected !== 'undefined' ? _this.props.valueSelected : _this.props.defaultSelected
    });

    _defineProperty(_assertThisInitialized(_this), "getRadioButtons", function () {
      var children = _react.default.Children.map(_this.props.children, function (radioButton) {
        var value = radioButton.props.value;
        /* istanbul ignore if */

        if (typeof radioButton.props.checked !== 'undefined') {
          process.env.NODE_ENV !== "production" ? (0, _warning.warning)(false, "Instead of using the checked property on the RadioButton, set\n            the defaultSelected property or valueSelected property on the RadioButtonGroup.") : void 0;
        }

        return /*#__PURE__*/_react.default.cloneElement(radioButton, {
          name: _this.props.name,
          key: value,
          value: value,
          onChange: _this.handleChange,
          checked: value === _this.state.selected
        });
      });

      return children;
    });

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (newSelection, value, evt) {
      if (newSelection !== _this.state.selected) {
        _this.setState({
          selected: newSelection
        });

        _this.props.onChange(newSelection, _this.props.name, evt);
      }
    });

    return _this;
  }

  _createClass(RadioButtonGroup, [{
    key: "render",
    value: function render() {
      var _classNames;

      var _this$props = this.props,
          disabled = _this$props.disabled,
          className = _this$props.className,
          orientation = _this$props.orientation,
          labelPosition = _this$props.labelPosition,
          legendText = _this$props.legendText;
      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--radio-button-group"), [enabled ? null : className], (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--radio-button-group--").concat(orientation), orientation === 'vertical'), _defineProperty(_classNames, "".concat(prefix, "--radio-button-group--label-").concat(labelPosition), labelPosition), _classNames));
      return /*#__PURE__*/_react.default.createElement("div", {
        className: enabled ? (0, _classnames.default)("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
      }, /*#__PURE__*/_react.default.createElement("fieldset", {
        className: wrapperClasses,
        disabled: disabled
      }, legendText && /*#__PURE__*/_react.default.createElement(_Text.Legend, {
        className: "".concat(prefix, "--label")
      }, legendText), this.getRadioButtons()));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var valueSelected = _ref.valueSelected,
          defaultSelected = _ref.defaultSelected;
      var prevValueSelected = state.prevValueSelected;
      return prevValueSelected === valueSelected ? null : {
        selected: typeof valueSelected !== 'undefined' ? valueSelected : defaultSelected,
        prevValueSelected: valueSelected
      };
    }
  }]);

  return RadioButtonGroup;
}(_react.default.Component);

exports.default = RadioButtonGroup;

_defineProperty(RadioButtonGroup, "propTypes", {
  /**
   * Provide a collection of <RadioButton> components to render in the group
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the <RadioButton> to be selected by default
   */
  defaultSelected: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the group is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide where label text should be placed
   */
  labelPosition: _propTypes.default.oneOf(['left', 'right']),

  /**
   * Provide a legend to the RadioButtonGroup input that you are
   * exposing to the user
   */
  legendText: _propTypes.default.node,

  /**
   * Specify the name of the underlying `<input>` nodes
   */
  name: _propTypes.default.string.isRequired,

  /**
   * Provide an optional `onChange` hook that is called whenever the value of
   * the group changes
   */
  onChange: _propTypes.default.func,

  /**
   * Provide where radio buttons should be placed
   */
  orientation: _propTypes.default.oneOf(['horizontal', 'vertical']),

  /**
   * Specify the value that is currently selected in the group
   */
  valueSelected: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
});

_defineProperty(RadioButtonGroup, "defaultProps", {
  orientation: 'horizontal',
  labelPosition: 'right',
  onChange:
  /* istanbul ignore next */
  function onChange() {}
});

_defineProperty(RadioButtonGroup, "contextType", _FeatureFlags.FeatureFlagContext);