"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Text = Text;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _TextDirectionContext = require("./TextDirectionContext");

var _excluded = ["as", "children", "dir"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function Text(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'span' : _ref$as,
      children = _ref.children,
      _ref$dir = _ref.dir,
      dir = _ref$dir === void 0 ? 'auto' : _ref$dir,
      rest = _objectWithoutProperties(_ref, _excluded);

  var context = (0, _react.useContext)(_TextDirectionContext.TextDirectionContext);
  var textProps = {};

  var value = _objectSpread({}, context);

  if (!context) {
    textProps.dir = dir;
    value.direction = dir;
  } else {
    var parentDirection = context.direction,
        getTextDirection = context.getTextDirection;

    if (getTextDirection && getTextDirection.current) {
      var text = getTextFromChildren(children);
      var override = getTextDirection.current(text);

      if (parentDirection !== override) {
        textProps.dir = override;
        value.direction = override;
      } else if (parentDirection === 'auto') {
        textProps.dir = override;
      }
    } else if (parentDirection !== dir) {
      textProps.dir = dir;
      value.direction = dir;
    } else if (parentDirection === 'auto') {
      textProps.dir = dir;
    }
  }

  return /*#__PURE__*/_react.default.createElement(_TextDirectionContext.TextDirectionContext.Provider, {
    value: value
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, _extends({}, rest, textProps), children));
}

Text.propTypes = {
  /**
   * Provide a custom element type used to render the outermost node
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide child elements or text to be rendered inside of this component
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Specify the text direction to be used for this component and any of its
   * children
   */
  dir: _propTypes.default.oneOf(['ltr', 'rtl', 'auto'])
};

function getTextFromChildren(children) {
  if (typeof children === 'string') {
    return children;
  }

  var text = _react.default.Children.map(children, function (child) {
    if (typeof child === 'string') {
      return child;
    }

    return null;
  }).filter(function (text) {
    return text !== null;
  });

  if (text.length === 1) {
    return text[0];
  }

  return text;
}