"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.classNameChangeTest = exports.Skeleton = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _TextArea = _interopRequireDefault(require("../TextArea"));

var _TextArea2 = _interopRequireDefault(require("../TextArea/TextArea.Skeleton"));

var _TextArea3 = _interopRequireDefault(require("./TextArea.mdx"));

var _FeatureFlags = require("../FeatureFlags");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var TextAreaProps = function TextAreaProps() {
  return {
    className: 'some-class',
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel)', false),
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Text Area label'),
    invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid)', false),
    invalidText: (0, _addonKnobs.text)('Content of form validation UI (invalidText)', 'A valid value is required'),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text.'),
    placeholder: (0, _addonKnobs.text)('Placeholder text (placeholder)', 'Placeholder text.'),
    id: 'test2',
    cols: (0, _addonKnobs.number)('Columns (columns)', 50),
    rows: (0, _addonKnobs.number)('Rows (rows)', 4),
    onChange: (0, _addonActions.action)('onChange'),
    onClick: (0, _addonActions.action)('onClick')
  };
};

var _default = {
  title: 'Components/TextArea',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _TextArea.default,
    docs: {
      page: _TextArea3.default
    },
    subcomponents: {
      TextAreaSkeleton: _TextArea2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_TextArea.default, TextAreaProps());
};

exports.Default = Default;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_TextArea2.default, null);
};

exports.Skeleton = Skeleton;

var classNameChangeTest = function classNameChangeTest() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_TextArea.default, {
    labelText: "Text area label",
    placeholder: "The class should be added to the label",
    helperText: "Optional helper text.",
    className: "TEST_CLASS"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/_react.default.createElement(_TextArea.default, {
    labelText: "Text area label",
    placeholder: "The class should be added to the wrapper",
    helperText: "Optional helper text.",
    className: "TEST_CLASS"
  })));
};

exports.classNameChangeTest = classNameChangeTest;