"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "id", "labelText", "hideLabel", "onChange", "onClick", "invalid", "invalidText", "helperText", "light", "placeholder"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var TextArea = /*#__PURE__*/_react.default.forwardRef(function TextArea(_ref, ref) {
  var _classNames, _classNames3;

  var className = _ref.className,
      id = _ref.id,
      labelText = _ref.labelText,
      hideLabel = _ref.hideLabel,
      _onChange = _ref.onChange,
      _onClick = _ref.onClick,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      helperText = _ref.helperText,
      light = _ref.light,
      placeholder = _ref.placeholder,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var textareaProps = {
    id: id,
    onChange: function onChange(evt) {
      if (!other.disabled) {
        _onChange(evt);
      }
    },
    onClick: function onClick(evt) {
      if (!other.disabled) {
        _onClick(evt);
      }
    },
    ref: ref
  };
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_classNames, "".concat(prefix, "--label--disabled"), other.disabled), _classNames));
  var label = labelText ? /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText) : null;
  var helperTextClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), _defineProperty({}, "".concat(prefix, "--form__helper-text--disabled"), other.disabled));
  var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
    className: helperTextClasses
  }, helperText) : null;
  var errorId = id + '-error-msg';
  var error = invalid ? /*#__PURE__*/_react.default.createElement("div", {
    role: "alert",
    className: "".concat(prefix, "--form-requirement"),
    id: errorId
  }, invalidText) : null;
  var textareaClasses = (0, _classnames.default)("".concat(prefix, "--text-area"), [enabled ? null : className], (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--text-area--light"), light), _defineProperty(_classNames3, "".concat(prefix, "--text-area--invalid"), invalid), _classNames3));

  var input = /*#__PURE__*/_react.default.createElement("textarea", _extends({}, other, textareaProps, {
    placeholder: placeholder || null,
    className: textareaClasses,
    "aria-invalid": invalid || null,
    "aria-describedby": invalid ? errorId : null,
    disabled: other.disabled
  }));

  return /*#__PURE__*/_react.default.createElement("div", {
    className: enabled ? (0, _classnames.default)("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
  }, label, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--text-area__wrapper"),
    "data-invalid": invalid || null
  }, invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
    className: "".concat(prefix, "--text-area__invalid-icon")
  }), input), invalid ? error : helper);
});

TextArea.displayName = 'TextArea';
TextArea.propTypes = {
  /**
   * Provide a custom className that is applied directly to the underlying
   * `<textarea>` node
   */
  className: _propTypes.default.string,

  /**
   * Specify the `cols` attribute for the underlying `<textarea>` node
   */
  cols: _propTypes.default.number,

  /**
   * Optionally provide the default value of the `<textarea>`
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the control is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Provide a unique identifier for the control
   */
  id: _propTypes.default.string,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: _propTypes.default.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Specify whether you want the light version of this control
   */
  light: _propTypes.default.bool,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<textarea>`
   * is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<textarea>` is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the placeholder attribute for the `<textarea>`
   */
  placeholder: _propTypes.default.string,

  /**
   * Specify the rows attribute for the `<textarea>`
   */
  rows: _propTypes.default.number,

  /**
   * Provide the current value of the `<textarea>`
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
};
TextArea.defaultProps = {
  disabled: false,
  onChange: function onChange() {},
  onClick: function onClick() {},
  placeholder: '',
  rows: 4,
  cols: 50,
  invalid: false,
  invalidText: '',
  helperText: '',
  light: false
};
var _default = TextArea;
exports.default = _default;