"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _useNormalizedInputProps = require("../../internal/useNormalizedInputProps");

var _PasswordInput = _interopRequireDefault(require("./PasswordInput"));

var _ControlledPasswordInput = _interopRequireDefault(require("./ControlledPasswordInput"));

var _util = require("./util");

var _FluidForm = require("../FluidForm");

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["labelText", "className", "id", "placeholder", "type", "onChange", "onClick", "hideLabel", "disabled", "invalid", "invalidText", "warn", "warnText", "helperText", "light", "size", "inline", "readOnly"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var TextInput = /*#__PURE__*/_react.default.forwardRef(function TextInput(_ref, ref) {
  var _classNames, _classNames2, _classNames3, _classNames4, _classNames7;

  var labelText = _ref.labelText,
      className = _ref.className,
      id = _ref.id,
      placeholder = _ref.placeholder,
      type = _ref.type,
      _onChange = _ref.onChange,
      _onClick = _ref.onClick,
      hideLabel = _ref.hideLabel,
      disabled = _ref.disabled,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      warn = _ref.warn,
      warnText = _ref.warnText,
      helperText = _ref.helperText,
      light = _ref.light,
      size = _ref.size,
      inline = _ref.inline,
      readOnly = _ref.readOnly,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var normalizedProps = (0, _useNormalizedInputProps.useNormalizedInputProps)({
    id: id,
    readOnly: readOnly,
    disabled: disabled,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText
  });
  var customClassName = className !== null && className !== void 0 ? className : "".concat(prefix, "--text__input");
  var textInputClasses = (0, _classnames.default)("".concat(prefix, "--text-input"), [enabled ? null : className], (_classNames = {}, _defineProperty(_classNames, customClassName, enabled), _defineProperty(_classNames, "".concat(prefix, "--text-input--light"), light), _defineProperty(_classNames, "".concat(prefix, "--text-input--invalid"), normalizedProps.invalid), _defineProperty(_classNames, "".concat(prefix, "--text-input--warning"), normalizedProps.warn), _defineProperty(_classNames, "".concat(prefix, "--text-input--").concat(size), size), _classNames));

  var sharedTextInputProps = _objectSpread({
    id: id,
    onChange: function onChange(evt) {
      if (!normalizedProps.disabled) {
        _onChange(evt);
      }
    },
    onClick: function onClick(evt) {
      if (!normalizedProps.disabled) {
        _onClick(evt);
      }
    },
    placeholder: placeholder,
    type: type,
    ref: ref,
    className: textInputClasses,
    title: placeholder,
    disabled: normalizedProps.disabled,
    readOnly: readOnly
  }, other);

  var inputWrapperClasses = (0, _classnames.default)([enabled ? (0, _classnames.default)("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")], "".concat(prefix, "--text-input-wrapper"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--readonly"), readOnly), _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--light"), light), _defineProperty(_classNames2, "".concat(prefix, "--text-input-wrapper--inline"), inline), _classNames2));
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_classNames3, "".concat(prefix, "--label--disabled"), normalizedProps.disabled), _defineProperty(_classNames3, "".concat(prefix, "--label--inline"), inline), _defineProperty(_classNames3, "".concat(prefix, "--label--inline--").concat(size), inline && !!size), _classNames3));
  var helperTextClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (_classNames4 = {}, _defineProperty(_classNames4, "".concat(prefix, "--form__helper-text--disabled"), normalizedProps.disabled), _defineProperty(_classNames4, "".concat(prefix, "--form__helper-text--inline"), inline), _classNames4));
  var fieldOuterWrapperClasses = (0, _classnames.default)("".concat(prefix, "--text-input__field-outer-wrapper"), _defineProperty({}, "".concat(prefix, "--text-input__field-outer-wrapper--inline"), inline));
  var fieldWrapperClasses = (0, _classnames.default)("".concat(prefix, "--text-input__field-wrapper"), _defineProperty({}, "".concat(prefix, "--text-input__field-wrapper--warning"), normalizedProps.warn));
  var iconClasses = (0, _classnames.default)((_classNames7 = {}, _defineProperty(_classNames7, "".concat(prefix, "--text-input__invalid-icon"), normalizedProps.invalid || normalizedProps.warn), _defineProperty(_classNames7, "".concat(prefix, "--text-input__invalid-icon--warning"), normalizedProps.warn), _defineProperty(_classNames7, "".concat(prefix, "--text-input__readonly-icon"), readOnly), _classNames7));
  var label = labelText ? /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText) : null;
  var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
    className: helperTextClasses
  }, helperText) : null;

  var input = /*#__PURE__*/_react.default.createElement("input", (0, _util.textInputProps)({
    sharedTextInputProps: sharedTextInputProps,
    invalid: normalizedProps.invalid,
    invalidId: normalizedProps.invalidId,
    warn: normalizedProps.warn,
    warnId: normalizedProps.warnId
  }));

  var _useContext = (0, _react.useContext)(_FluidForm.FormContext),
      isFluid = _useContext.isFluid;

  return /*#__PURE__*/_react.default.createElement("div", {
    className: inputWrapperClasses
  }, !inline ? label : /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--text-input__label-helper-wrapper")
  }, label, !isFluid && helper), /*#__PURE__*/_react.default.createElement("div", {
    className: fieldOuterWrapperClasses
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: fieldWrapperClasses,
    "data-invalid": normalizedProps.invalid || null
  }, normalizedProps.icon && /*#__PURE__*/_react.default.createElement(normalizedProps.icon, {
    className: iconClasses
  }), input, isFluid && /*#__PURE__*/_react.default.createElement("hr", {
    className: "".concat(prefix, "--text-input__divider")
  }), isFluid && !inline && normalizedProps.validation), !isFluid && !inline && (normalizedProps.validation || helper)));
});

TextInput.displayName = 'TextInput';
TextInput.PasswordInput = _PasswordInput.default;
TextInput.ControlledPasswordInput = _ControlledPasswordInput.default;
TextInput.propTypes = {
  /**
   * Specify an optional className to be applied to the `<input>` node
   */
  className: _propTypes.default.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify a custom `id` for the `<input>`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * `true` to use the inline version.
   */
  inline: _propTypes.default.bool,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: _propTypes.default.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<input>`
   * is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<input>` is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the placeholder attribute for the `<input>`
   */
  placeholder: _propTypes.default.string,

  /**
   * Whether the input should be read-only
   */
  readOnly: _propTypes.default.bool,

  /**
   * Specify the size of the Text Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify the type of the `<input>`
   */
  type: _propTypes.default.string,

  /**
   * Specify the value of the `<input>`
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
};
TextInput.defaultProps = {
  disabled: false,
  type: 'text',
  onChange: function onChange() {},
  onClick: function onClick() {},
  invalid: false,
  invalidText: '',
  warn: false,
  warnText: '',
  helperText: '',
  light: false,
  inline: false
};
var _default = TextInput;
exports.default = _default;