"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Expandable = exports.Radio = exports.MultiSelect = exports.Clickable = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

require("./tile-story.scss");

var _addonKnobs = require("@storybook/addon-knobs");

var _Tile = require("../Tile");

var _TextInput = _interopRequireDefault(require("../TextInput"));

var _TileGroup = _interopRequireDefault(require("../TileGroup"));

var _RadioTile = _interopRequireDefault(require("../RadioTile"));

var _Link = _interopRequireDefault(require("../Link"));

var _Tile2 = _interopRequireDefault(require("./Tile.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var radioValues = {
  None: '',
  standard: 'standard',
  'default-selected': 'default-selected',
  selected: 'selected'
};
var props = {
  regular: function regular() {
    return {
      light: (0, _addonKnobs.boolean)('Light variant (light)', false)
    };
  },
  clickable: function clickable() {
    return {
      disabled: (0, _addonKnobs.boolean)('disabled (disabled)', false),
      href: (0, _addonKnobs.text)('Href for clickable UI (href)', 'https://www.carbondesignsystem.com/'),
      light: (0, _addonKnobs.boolean)('Light variant (light)', false)
    };
  },
  selectable: function selectable() {
    return {
      selected: (0, _addonKnobs.boolean)('Selected (selected)', false),
      light: (0, _addonKnobs.boolean)('Light variant (light)', false),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false)
    };
  },
  group: function group() {
    return {
      name: (0, _addonKnobs.text)('Form item (name in <TileGroup>)', 'tile-group'),
      valueSelected: (0, _addonKnobs.select)('Value of the selected item (valueSelected in <TileGroup>)', radioValues, '')
    };
  },
  radio: function radio() {
    return {
      name: (0, _addonKnobs.text)('Form item name (name in <RadioTile>)', 'tiles'),
      light: (0, _addonKnobs.boolean)('Light variant (light)', false),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false)
    };
  },
  expandable: function expandable() {
    return {
      tabIndex: (0, _addonKnobs.number)('Tab index (tabIndex)', 0),
      expanded: (0, _addonKnobs.boolean)('Expanded (expanded)', false),
      tileCollapsedIconText: (0, _addonKnobs.text)('Collapsed icon text (tileCollapsedIconText)', 'Interact to Expand tile'),
      tileExpandedIconText: (0, _addonKnobs.text)('Collapsed icon text (tileExpandedIconText)', 'Interact to Collapse tile'),
      tileCollapsedLabel: (0, _addonKnobs.text)('Collapsed icon text (tileCollapsedLabel)'),
      tileExpandedLabel: (0, _addonKnobs.text)('Collapsed icon text (tileExpandedLabel)'),
      light: (0, _addonKnobs.boolean)('Light variant (light)', false)
    };
  }
};
var _default = {
  title: 'Components/Tile',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Tile.Tile,
    docs: {
      page: _Tile2.default
    },
    subcomponents: {
      ClickableTile: _Tile.ClickableTile,
      SelectableTile: _Tile.SelectableTile,
      ExpandableTile: _Tile.ExpandableTile,
      RadioTile: _RadioTile.default,
      TileGroup: _TileGroup.default,
      TileAboveTheFoldContent: _Tile.TileAboveTheFoldContent,
      TileBelowTheFoldContent: _Tile.TileBelowTheFoldContent
    }
  }
};
exports.default = _default;

var Default = function Default() {
  var regularProps = props.regular();
  return /*#__PURE__*/_react.default.createElement(_Tile.Tile, regularProps, "Default tile", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Link.default, {
    href: "https://www.carbondesignsystem.com"
  }, "Link"));
};

exports.Default = Default;

var Clickable = function Clickable() {
  var clickableProps = props.clickable();
  return /*#__PURE__*/_react.default.createElement(_Tile.ClickableTile, clickableProps, "Clickable Tile");
};

exports.Clickable = Clickable;

var MultiSelect = function MultiSelect() {
  var selectableProps = props.selectable();
  return /*#__PURE__*/_react.default.createElement("div", {
    role: "group",
    "aria-label": "selectable tiles"
  }, /*#__PURE__*/_react.default.createElement(_Tile.SelectableTile, _extends({
    id: "tile-1",
    name: "tiles"
  }, selectableProps), "Option 1"), /*#__PURE__*/_react.default.createElement(_Tile.SelectableTile, _extends({
    id: "tile-2",
    name: "tiles"
  }, selectableProps), "Option 2"), /*#__PURE__*/_react.default.createElement(_Tile.SelectableTile, _extends({
    id: "tile-3",
    name: "tiles"
  }, selectableProps), "Option 3"));
};

exports.MultiSelect = MultiSelect;

var Radio = function Radio() {
  var radioProps = props.radio();
  return /*#__PURE__*/_react.default.createElement(_TileGroup.default, _extends({
    defaultSelected: "default-selected",
    legend: "Radio Tile Group"
  }, props.group()), /*#__PURE__*/_react.default.createElement(_RadioTile.default, _extends({
    value: "standard"
  }, radioProps), "Option 1"), /*#__PURE__*/_react.default.createElement(_RadioTile.default, _extends({
    value: "default-selected",
    id: "tile-2"
  }, radioProps), "Option 2"), /*#__PURE__*/_react.default.createElement(_RadioTile.default, _extends({
    value: "selected",
    id: "tile-3"
  }, radioProps), "Option 3"));
};

exports.Radio = Radio;

var Expandable = function Expandable() {
  return /*#__PURE__*/_react.default.createElement(_Tile.ExpandableTile, props.expandable(), /*#__PURE__*/_react.default.createElement(_Tile.TileAboveTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Above the fold content here")), /*#__PURE__*/_react.default.createElement(_Tile.TileBelowTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "test2",
    invalidText: "A valid value is required"
  })), /*#__PURE__*/_react.default.createElement(_Link.default, null, "hello")));
};

exports.Expandable = Expandable;