"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _keyboard = require("../../internal/keyboard");

var _warning = require("../../internal/warning");

var _ToggleSmall$propType;

var _excluded = ["className", "defaultToggled", "toggled", "onChange", "onToggle", "id", "labelText", "labelA", "labelB"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
var didWarnAboutDeprecation = false;

var ToggleSmall = function ToggleSmall(_ref) {
  var className = _ref.className,
      defaultToggled = _ref.defaultToggled,
      toggled = _ref.toggled,
      _onChange = _ref.onChange,
      onToggle = _ref.onToggle,
      id = _ref.id,
      labelText = _ref.labelText,
      labelA = _ref.labelA,
      labelB = _ref.labelB,
      other = _objectWithoutProperties(_ref, _excluded);

  if (process.env.NODE_ENV !== "production") {
    process.env.NODE_ENV !== "production" ? (0, _warning.warning)(didWarnAboutDeprecation, '`<ToggleSmall>` has been deprecated in favor of `<Toggle size="sm" />` and will be removed in the next major release of `carbon-components-react`') : void 0;
    didWarnAboutDeprecation = true;
  }

  var input;
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--form-item"), _defineProperty({}, className, className));
  var checkedProps = {};

  if (typeof toggled !== 'undefined') {
    checkedProps.checked = toggled;
  } else {
    checkedProps.defaultChecked = defaultToggled;
  }

  var ariaLabel = typeof labelText === 'string' && labelText || other['aria-label'] || other.ariaLabel || null;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/_react.default.createElement("input", _extends({}, other, checkedProps, {
    "aria-label": null,
    type: "checkbox",
    id: id,
    className: "".concat(prefix, "--toggle-input ").concat(prefix, "--toggle-input--small"),
    onChange: function onChange(evt) {
      _onChange && _onChange(evt);
      onToggle(input.checked, id, evt);
    },
    ref: function ref(el) {
      input = el;
    },
    onKeyUp: function onKeyUp(evt) {
      if ((0, _keyboard.match)(evt, _keyboard.keys.Enter)) {
        input.checked = !input.checked;
        _onChange && _onChange(evt);
        onToggle(input.checked, id, evt);
      }
    }
  })), /*#__PURE__*/_react.default.createElement("label", {
    className: "".concat(prefix, "--toggle-input__label"),
    htmlFor: id,
    "aria-label": ariaLabel
  }, labelText, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--toggle__switch")
  }, /*#__PURE__*/_react.default.createElement("svg", {
    className: "".concat(prefix, "--toggle__check"),
    width: "6px",
    height: "5px",
    viewBox: "0 0 6 5"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.2 2.7L5 0 6 1 2.2 5 0 2.7 1 1.5z"
  })), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--toggle__text--off"),
    "aria-hidden": "true"
  }, labelA), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--toggle__text--on"),
    "aria-hidden": "true"
  }, labelB))));
};

ToggleSmall.propTypes = (_ToggleSmall$propType = {}, _defineProperty(_ToggleSmall$propType, 'aria-label', _propTypes.default.string.isRequired), _defineProperty(_ToggleSmall$propType, "className", _propTypes.default.string), _defineProperty(_ToggleSmall$propType, "defaultToggled", _propTypes.default.bool), _defineProperty(_ToggleSmall$propType, "id", _propTypes.default.string.isRequired), _defineProperty(_ToggleSmall$propType, "labelA", _propTypes.default.node.isRequired), _defineProperty(_ToggleSmall$propType, "labelB", _propTypes.default.node.isRequired), _defineProperty(_ToggleSmall$propType, "labelText", _propTypes.default.node), _defineProperty(_ToggleSmall$propType, "onChange", _propTypes.default.func), _defineProperty(_ToggleSmall$propType, "onToggle", _propTypes.default.func), _defineProperty(_ToggleSmall$propType, "toggled", _propTypes.default.bool), _ToggleSmall$propType);
ToggleSmall.defaultProps = {
  defaultToggled: false,
  onToggle: function onToggle() {},
  labelA: 'Off',
  labelB: 'On'
};
var _default = ToggleSmall;
exports.default = _default;